/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalModuleBuilder<S extends ExternalProjectSettings>
extends ModuleBuilder {
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final S myExternalProjectSettings;

    protected AbstractExternalModuleBuilder(@NotNull ProjectSystemId externalSystemId, @NotNull S externalProjectSettings) {
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectSettings = externalProjectSettings;
        Icon icon = ExternalSystemUiUtil.getUiAware(externalSystemId).getProjectIcon();
        this.myIcon = icon == null ? super.getNodeIcon() : icon;
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getDescription() {
        return ExternalSystemBundle.message((String)"module.type.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getNodeIcon() {
        return this.myIcon;
    }

    @NotNull
    public S getExternalProjectSettings() {
        return this.myExternalProjectSettings;
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project = super.createProject(name, path);
        if (project != null) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        return project;
    }
}

