/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectImportBuilder<C extends AbstractImportFromExternalSystemControl>
extends ProjectImportBuilder<DataNode<ProjectData>> {
    private static final Logger LOG = Logger.getInstance(AbstractExternalProjectImportBuilder.class);
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final NotNullLazyValue<C> myControlValue;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    private DataNode<ProjectData> myExternalProjectNode;

    @Deprecated
    public AbstractExternalProjectImportBuilder(@NotNull com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        this((ProjectDataManager)projectDataManager, control, externalSystemId);
    }

    @Deprecated
    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull C control, @NotNull ProjectSystemId externalSystemId) {
        this.myProjectDataManager = projectDataManager;
        this.myControlValue = NotNullLazyValue.createValue(() -> control);
        this.myExternalSystemId = externalSystemId;
    }

    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull NotNullFactory<? extends C> controlFactory, @NotNull ProjectSystemId externalSystemId) {
        this.myProjectDataManager = projectDataManager;
        this.myControlValue = NotNullLazyValue.createValue(controlFactory);
        this.myExternalSystemId = externalSystemId;
    }

    public List<DataNode<ProjectData>> getList() {
        return Collections.singletonList(this.myExternalProjectNode);
    }

    public boolean isMarked(DataNode<ProjectData> element) {
        return true;
    }

    public void setList(List<DataNode<ProjectData>> externalSystemProjects) {
    }

    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @NotNull
    public C getControl(@Nullable Project currentProject) {
        C control = this.getControl();
        ((AbstractImportFromExternalSystemControl)control).setCurrentProject(currentProject);
        return control;
    }

    public void prepare(@NotNull WizardContext context) {
        if (context.getProjectJdk() == null) {
            context.setProjectJdk(this.resolveProjectJdk(context));
        }
        C control = this.getControl();
        ((AbstractImportFromExternalSystemControl)control).setShowProjectFormatPanel(context.isCreatingNewProject());
        ((AbstractImportFromExternalSystemControl)control).reset(context, null);
        String pathToUse = this.getFileToImport();
        ((AbstractImportFromExternalSystemControl)control).setLinkedProjectPath(pathToUse);
        this.doPrepare(context);
    }

    @Nullable
    protected Sdk resolveProjectJdk(@NotNull WizardContext context) {
        Project project = context.getProject() != null ? context.getProject() : ProjectManager.getInstance().getDefaultProject();
        Pair<String, Sdk> sdkPair = ExternalSystemJdkUtil.getAvailableJdk(project);
        if (!"#JAVA_INTERNAL".equals(sdkPair.first)) {
            return (Sdk)sdkPair.second;
        }
        return null;
    }

    protected abstract void doPrepare(@NotNull WizardContext var1);

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        DataNode<ProjectData> externalProjectNode = this.getExternalProjectNode();
        if (externalProjectNode != null) {
            this.beforeCommit(externalProjectNode, project);
        }
        boolean isFromUI = model != null;
        final List modules = ContainerUtil.newSmartList();
        final IdentityHashMap moduleMap = ContainerUtil.newIdentityHashMap();
        AbstractIdeModifiableModelsProvider modelsProvider = isFromUI ? new IdeUIModifiableModelsProvider(project, model, (ModulesConfigurator)modulesProvider, artifactModel){

            @Override
            protected ModifiableRootModel doGetModifiableRootModel(Module module) {
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module);
                moduleMap.put(modifiableRootModel, module);
                return modifiableRootModel;
            }

            @Override
            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    modules.add(moduleEntry.getValue());
                }
            }
        } : new IdeModifiableModelsProviderImpl(project){

            @Override
            @NotNull
            protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module) {
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module);
                moduleMap.put(modifiableRootModel, module);
                return modifiableRootModel;
            }

            @Override
            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    if (((ModifiableRootModel)moduleEntry.getKey()).isWritable()) continue;
                    modules.add(moduleEntry.getValue());
                }
            }
        };
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)this.myExternalSystemId);
        ExternalProjectSettings projectSettings = this.getCurrentExternalProjectSettings();
        HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
        projects.remove(projectSettings);
        projects.add(projectSettings);
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)this.getControl()).getSystemSettings());
        systemSettings.setLinkedProjectsSettings((Collection)projects);
        if (externalProjectNode != null) {
            if (systemSettings.showSelectiveImportDialogOnInitialImport() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(project, new InternalExternalProjectInfo(this.myExternalSystemId, projectSettings.getExternalProjectPath(), externalProjectNode));
                if (dialog.hasMultipleDataToSelect()) {
                    dialog.showAndGet();
                } else {
                    Disposer.dispose((Disposable)dialog.getDisposable());
                }
            }
            if (!project.isInitialized()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> this.finishImport(project, externalProjectNode, isFromUI, modules, modelsProvider, projectSettings));
            } else {
                this.finishImport(project, externalProjectNode, isFromUI, modules, modelsProvider, projectSettings);
            }
        }
        return modules;
    }

    protected void finishImport(Project project, DataNode<ProjectData> externalProjectNode, boolean isFromUI, List<Module> modules, IdeModifiableModelsProvider modelsProvider, ExternalProjectSettings projectSettings) {
        this.myProjectDataManager.importData(externalProjectNode, project, modelsProvider, true);
        this.myExternalProjectNode = null;
        Runnable resolveDependenciesTask = () -> ExternalSystemUtil.refreshProject(project, this.myExternalSystemId, projectSettings.getExternalProjectPath(), this.createFinalImportCallback(project, projectSettings), false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, true);
        if (!isFromUI) {
            resolveDependenciesTask.run();
        } else {
            ExternalSystemUtil.invokeLater(project, ModalityState.NON_MODAL, () -> {
                Object[] committedModules = ModuleManager.getInstance((Project)project).getModules();
                if (ContainerUtil.list((Object[])committedModules).containsAll(modules)) {
                    resolveDependenciesTask.run();
                }
            });
        }
    }

    protected ExternalProjectRefreshCallback createFinalImportCallback(final @NotNull Project project, @NotNull ExternalProjectSettings projectSettings) {
        return new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project, false);
            }
        };
    }

    @NotNull
    private ExternalProjectSettings getCurrentExternalProjectSettings() {
        ExternalProjectSettings result = ((AbstractImportFromExternalSystemControl)this.getControl()).getProjectSettings().clone();
        File externalProjectConfigFile = this.getExternalProjectConfigToUse(new File(result.getExternalProjectPath()));
        String linkedProjectPath = FileUtil.toCanonicalPath((String)externalProjectConfigFile.getPath());
        assert (linkedProjectPath != null);
        result.setExternalProjectPath(linkedProjectPath);
        return result;
    }

    protected abstract void beforeCommit(@NotNull DataNode<ProjectData> var1, @NotNull Project var2);

    @Nullable
    private File getProjectFile() {
        String path = ((AbstractImportFromExternalSystemControl)this.getControl()).getProjectSettings().getExternalProjectPath();
        return path == null ? null : new File(path);
    }

    public void ensureProjectIsDefined(@NotNull WizardContext wizardContext) throws ConfigurationException {
        String externalSystemName = this.myExternalSystemId.getReadableName();
        File projectFile = this.getProjectFile();
        if (projectFile == null) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        projectFile = this.getExternalProjectConfigToUse(projectFile);
        final Ref error = new Ref();
        ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                AbstractExternalProjectImportBuilder.this.myExternalProjectNode = externalProject;
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (!StringUtil.isEmpty((String)errorDetails)) {
                    LOG.warn(errorDetails);
                }
                error.set((Object)new ConfigurationException(ExternalSystemBundle.message((String)"error.resolve.with.log_link", (Object[])new Object[]{errorMessage, PathManager.getLogPath()}), ExternalSystemBundle.message((String)"error.resolve.generic", (Object[])new Object[0])));
            }
        };
        Project project = this.getProject(wizardContext);
        File finalProjectFile = projectFile;
        String externalProjectPath = FileUtil.toCanonicalPath((String)finalProjectFile.getAbsolutePath());
        Ref exRef = new Ref();
        this.executeAndRestoreDefaultProjectSettings(project, () -> {
            try {
                ExternalSystemUtil.refreshProject(project, this.myExternalSystemId, externalProjectPath, callback, true, ProgressExecutionMode.MODAL_SYNC);
            }
            catch (IllegalArgumentException e) {
                exRef.set((Object)new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName})));
            }
        });
        ConfigurationException ex = (ConfigurationException)((Object)exRef.get());
        if (ex != null) {
            throw ex;
        }
        if (this.myExternalProjectNode == null) {
            ConfigurationException exception = (ConfigurationException)((Object)error.get());
            if (exception != null) {
                throw exception;
            }
        } else {
            this.applyProjectSettings(wizardContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndRestoreDefaultProjectSettings(@NotNull Project project, @NotNull Runnable task) {
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)this.myExternalSystemId);
        Object systemStateToRestore = null;
        if (systemSettings instanceof PersistentStateComponent) {
            systemStateToRestore = ((PersistentStateComponent)systemSettings).getState();
        }
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)this.getControl()).getSystemSettings());
        Collection projectSettingsToRestore = systemSettings.getLinkedProjectsSettings();
        HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
        projects.add(this.getCurrentExternalProjectSettings());
        systemSettings.setLinkedProjectsSettings((Collection)projects);
        try {
            task.run();
        }
        finally {
            if (systemStateToRestore != null) {
                ((PersistentStateComponent)systemSettings).loadState(systemStateToRestore);
            } else {
                systemSettings.setLinkedProjectsSettings(projectSettingsToRestore);
            }
        }
    }

    @NotNull
    protected abstract File getExternalProjectConfigToUse(@NotNull File var1);

    @Nullable
    public DataNode<ProjectData> getExternalProjectNode() {
        return this.myExternalProjectNode;
    }

    public void applyProjectSettings(@NotNull WizardContext context) {
        if (this.myExternalProjectNode == null) {
            assert (false);
            return;
        }
        context.setProjectName(((ProjectData)this.myExternalProjectNode.getData()).getInternalName());
        context.setProjectFileDirectory(((ProjectData)this.myExternalProjectNode.getData()).getIdeProjectFileDirectoryPath());
        this.applyExtraSettings(context);
    }

    protected abstract void applyExtraSettings(@NotNull WizardContext var1);

    @NotNull
    public Project getProject(@NotNull WizardContext wizardContext) {
        Project result = wizardContext.getProject();
        if (result == null) {
            result = ProjectManager.getInstance().getDefaultProject();
        }
        return result;
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project = super.createProject(name, path);
        if (project != null) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        return project;
    }

    @NotNull
    private C getControl() {
        return (C)((AbstractImportFromExternalSystemControl)this.myControlValue.getValue());
    }
}

