/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote.wrapper;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.AbstractRemoteExternalSystemServiceWrapper;
import java.rmi.RemoteException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskManagerWrapper<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemServiceWrapper<S, RemoteExternalSystemTaskManager<S>>
implements RemoteExternalSystemTaskManager<S> {
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;

    public ExternalSystemTaskManagerWrapper(@NotNull RemoteExternalSystemTaskManager<S> delegate, @NotNull RemoteExternalSystemProgressNotificationManager progressManager) {
        super(delegate);
        this.myProgressManager = progressManager;
    }

    @Override
    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable S settings, @Nullable String jvmAgentSetup) throws RemoteException, ExternalSystemException {
        try {
            ((RemoteExternalSystemTaskManager)this.getDelegate()).executeTasks(id, taskNames, projectPath, settings, jvmAgentSetup);
            this.myProgressManager.onSuccess(id);
        }
        catch (ExternalSystemException e) {
            this.myProgressManager.onFailure(id, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.myProgressManager.onFailure(id, e);
            throw new ExternalSystemException((Throwable)e);
        }
        finally {
            this.myProgressManager.onEnd(id);
        }
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws RemoteException, ExternalSystemException {
        return ((RemoteExternalSystemTaskManager)this.getDelegate()).cancelTask(id);
    }
}

