/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id) {
        this.myExternalSystemId = id;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        toolWindow.setTitle(this.myExternalSystemId.getReadableName());
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent((Content)new ContentImpl((JComponent)this.createInitializingLabel(), "", false));
        ExternalProjectsManager.getInstance((Project)project).runWhenInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            ExternalProjectsViewImpl projectsView = new ExternalProjectsViewImpl(project, (ToolWindowEx)toolWindow, this.myExternalSystemId);
            ExternalProjectsManagerImpl.getInstance(project).registerView(projectsView);
            ContentImpl tasksContent = new ContentImpl((JComponent)((Object)projectsView), "", true);
            contentManager.removeAllContents(true);
            contentManager.addContent((Content)tasksContent);
        }, project.getDisposed()));
    }

    @NotNull
    private JLabel createInitializingLabel() {
        JLabel label = new JLabel("Initializing " + this.myExternalSystemId.getReadableName() + " projects data...", 0);
        label.setOpaque(true);
        return label;
    }
}

