/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final int MAX_PATH_LENGTH = 50;
    @Nullable
    private Project myProject;
    @Nullable
    private Sdk myProjectJdk;
    private boolean suggestJre = true;

    public ExternalSystemJdkComboBox() {
        this(null);
    }

    public ExternalSystemJdkComboBox(@Nullable Project project) {
        this.myProject = project;
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList list, JdkComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    return;
                }
                CompositeAppearance appearance = new CompositeAppearance();
                appearance.setIcon(AllIcons.Nodes.PpJdk);
                SimpleTextAttributes attributes = ExternalSystemJdkComboBox.getTextAttributes(value.valid, selected);
                CompositeAppearance.DequeEnd ending = appearance.getEnding();
                ending.addText(value.label, attributes);
                if (value.comment != null && !value.comment.equals(value.jdkName)) {
                    SimpleTextAttributes textAttributes = !value.valid ? SimpleTextAttributes.ERROR_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
                    ending.addComment(value.comment, textAttributes);
                }
                CompositeAppearance compositeAppearance = ending.getAppearance();
                compositeAppearance.customize((SimpleColoredComponent)this);
            }
        });
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    public void setProjectJdk(@Nullable Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
    }

    public void setSetupButton(@NotNull JButton setUpButton, @NotNull ProjectSdksModel jdksModel, @Nullable String actionGroupTitle, @Nullable Condition<SdkTypeId> creationFilter) {
        this.setSetupButton(setUpButton, jdksModel, actionGroupTitle, creationFilter, null);
    }

    public void setSetupButton(@NotNull JButton setUpButton, final @NotNull ProjectSdksModel jdksModel, @Nullable String actionGroupTitle, @Nullable Condition<SdkTypeId> creationFilter, @Nullable WizardContext wizardContext) {
        Arrays.stream(setUpButton.getActionListeners()).forEach(setUpButton::removeActionListener);
        setUpButton.addActionListener(e -> {
            DefaultActionGroup group = new DefaultActionGroup();
            final Sdk selectedJdk = this.getSelectedJdk();
            final Consumer updateTree = jdk -> {
                String jdkName;
                Sdk existingJdk = Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)jdk.getHomePath())).findFirst().orElse(null);
                if (existingJdk == null) {
                    SdkConfigurationUtil.addSdk((Sdk)jdk);
                    jdkName = jdk.getName();
                } else {
                    jdkName = existingJdk.getName();
                }
                this.refreshData(jdkName, wizardContext != null ? wizardContext.getProjectJdk() : null);
            };
            jdksModel.createAddActions(group, (JComponent)((Object)this), selectedJdk, updateTree, creationFilter);
            if (group.getChildrenCount() == 0) {
                final SimpleJavaSdkType javaSdkType = SimpleJavaSdkType.getInstance();
                DumbAwareAction addAction = new DumbAwareAction(javaSdkType.getPresentableName(), null, javaSdkType.getIconForAddAction()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        jdksModel.doAdd((JComponent)((Object)ExternalSystemJdkComboBox.this), selectedJdk, (SdkType)javaSdkType, updateTree);
                    }
                };
                group.add((AnAction)addAction);
            }
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (group.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            } else if (group.getChildrenCount() == 1) {
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                group.getChildren(event)[0].actionPerformed(event);
            }
        });
    }

    @Nullable
    public Sdk getSelectedJdk() {
        String jdkName = this.getSelectedValue();
        Sdk jdk = null;
        try {
            jdk = ExternalSystemJdkUtil.resolveJdkName(this.myProjectJdk, jdkName);
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            // empty catch block
        }
        return jdk;
    }

    @NotNull
    public ExternalSystemJdkComboBox withoutJre() {
        this.suggestJre = false;
        return this;
    }

    public void refreshData(@Nullable String selectedValue) {
        this.refreshData(selectedValue, null);
    }

    public void refreshData(@Nullable String selectedValue, @Nullable Sdk projectJdk) {
        this.myProjectJdk = projectJdk;
        Map<String, JdkComboBoxItem> jdkMap = this.collectComboBoxItem();
        if (selectedValue != null && !jdkMap.containsKey(selectedValue)) {
            assert (selectedValue.length() > 0);
            jdkMap.put(selectedValue, new JdkComboBoxItem(selectedValue, selectedValue, "", false));
        }
        this.removeAllItems();
        ComboBoxModel comboBoxModel = this.getModel();
        for (Map.Entry<String, JdkComboBoxItem> entry : jdkMap.entrySet()) {
            ((MutableComboBoxModel)comboBoxModel).addElement(entry.getValue());
        }
        ExternalSystemJdkComboBox.select(comboBoxModel, selectedValue);
    }

    @ApiStatus.Experimental
    public static void select(@NotNull ComboBoxModel<? extends JdkComboBoxItem> model, @Nullable String value) {
        for (int i = 0; i < model.getSize(); ++i) {
            JdkComboBoxItem item = (JdkComboBoxItem)model.getElementAt(i);
            if (!item.jdkName.equals(value)) continue;
            model.setSelectedItem(item);
            return;
        }
        if (model.getSize() != 0) {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    @Nullable
    public String getSelectedValue() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object item = model.getSelectedItem();
        return item != null ? ((JdkComboBoxItem)item).jdkName : null;
    }

    private Map<String, JdkComboBoxItem> collectComboBoxItem() {
        String javaHomePath;
        LinkedHashMap<String, JdkComboBoxItem> result = new LinkedHashMap<String, JdkComboBoxItem>();
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            SdkTypeId sdkType = sdk.getSdkType();
            if (!(sdkType instanceof JavaSdkType) || !(sdkType instanceof SdkType) || !((SdkType)sdkType).sdkHasValidPath(sdk)) continue;
            String name = sdk.getName();
            String comment = ExternalSystemJdkComboBox.buildComment(sdk);
            result.put(name, new JdkComboBoxItem(name, name, comment, true));
        }
        if (this.suggestJre) {
            Sdk internalJdk = ExternalSystemJdkUtil.getJdk(null, "#JAVA_INTERNAL");
            assert (internalJdk != null);
            assert (internalJdk.getHomePath() != null);
            result.put("#JAVA_INTERNAL", new JdkComboBoxItem("#JAVA_INTERNAL", ExternalSystemBundle.message((String)"external.system.java.internal.jre", (Object[])new Object[0]), ExternalSystemJdkComboBox.buildComment(internalJdk), true));
        }
        if (this.myProjectJdk == null && this.myProject != null && !this.myProject.isDisposed()) {
            this.myProjectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        if (this.myProjectJdk != null) {
            result.put("#USE_PROJECT_JDK", new JdkComboBoxItem("#USE_PROJECT_JDK", "Use Project JDK", ExternalSystemJdkComboBox.buildComment(this.myProjectJdk), true));
        }
        if (ExternalSystemJdkUtil.isValidJdk(javaHomePath = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            result.put("#JAVA_HOME", new JdkComboBoxItem("#JAVA_HOME", ExternalSystemBundle.message((String)"external.system.java.home.env", (Object[])new Object[0]), ExternalSystemJdkComboBox.truncateLongPath(javaHomePath), true));
        }
        return result;
    }

    private static String buildComment(@NotNull Sdk sdk) {
        String versionString = sdk.getVersionString();
        String path = sdk.getHomePath();
        StringBuilder buf = new StringBuilder();
        if (versionString != null) {
            buf.append(versionString);
        }
        if (path != null) {
            buf.append(versionString != null ? ", " : "");
            buf.append("path: ").append(ExternalSystemJdkComboBox.truncateLongPath(path));
        }
        return buf.toString();
    }

    @NotNull
    private static String truncateLongPath(@NotNull String path) {
        if (path.length() > 50) {
            return path.substring(0, 25) + "..." + path.substring(path.length() - 25 - 3);
        }
        return path;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    static class JdkComboBoxItem {
        private final String jdkName;
        private final String label;
        private final String comment;
        private final boolean valid;

        JdkComboBoxItem(String jdkName, String label, String comment, boolean valid) {
            this.jdkName = jdkName;
            this.label = label;
            this.comment = comment;
            this.valid = valid;
        }
    }
}

