/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.StatUtilKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.tools.state";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Set usages = new LinkedHashSet();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            String systemId = StatUtilKt.getAnonymizedSystemId(manager.getSystemId());
            Function1<UsageDescriptor, Unit> addWithSystemId$ = new Function1<UsageDescriptor, Unit>(systemId, usages){
                final /* synthetic */ String $systemId;
                final /* synthetic */ Set $usages;

                public final void invoke(@NotNull UsageDescriptor desc) {
                    desc.getData().addData("externalSystemId", this.$systemId);
                    this.$usages.add(desc);
                }
                {
                    this.$systemId = string;
                    this.$usages = set;
                    super(1);
                }
            };
            Collection projects = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings();
            addWithSystemId$.invoke(StatisticsUtilKt.getCountingUsage((String)"numberOfLinkedProject", (int)projects.size()));
            for (ExternalProjectSettings projectsSetting : projects) {
                addWithSystemId$.invoke(StatisticsUtilKt.getBooleanUsage((String)"autoImport", (boolean)projectsSetting.isUseAutoImport()));
                addWithSystemId$.invoke(StatisticsUtilKt.getBooleanUsage((String)"useQualifiedModuleNames", (boolean)projectsSetting.isUseQualifiedModuleNames()));
                addWithSystemId$.invoke(StatisticsUtilKt.getCountingUsage((String)"modules.count", (int)projectsSetting.getModules().size()));
            }
        }
        return usages;
    }
}

