/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.statistics.StatUtilKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Version;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemUsagesCollector
extends ProjectUsagesCollector {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getGroupId() {
        return "build.tools";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Set usages;
        block3: {
            Module module;
            Module[] moduleArray;
            block2: {
                usages = new LinkedHashSet();
                Module[] moduleArray2 = ExternalSystemApiUtil.getAllManagers().iterator();
                while (moduleArray2.hasNext()) {
                    ExternalSystemManager manager = (ExternalSystemManager)moduleArray2.next();
                    if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings().isEmpty()) continue;
                    usages.add(new UsageDescriptor(StatUtilKt.getAnonymizedSystemId(manager.getSystemId())));
                }
                Module[] moduleArray3 = moduleArray2 = (moduleArray = ModuleManager.getInstance((Project)project).getModules());
                int n = moduleArray3.length;
                for (int i = 0; i < n; ++i) {
                    Module module2;
                    Module it = module2 = moduleArray3[i];
                    boolean bl = false;
                    if (!ExternalSystemModulePropertyManager.Companion.getInstance(it).isMavenized()) continue;
                    module = module2;
                    break block2;
                }
                module = null;
            }
            if (module == null) break block3;
            Module[] it = moduleArray = module;
            boolean bl = false;
            usages.add(new UsageDescriptor("Maven"));
        }
        return usages;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$Companion;", "", "()V", "getJRETypeUsage", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "key", "", "jreName", "getJREVersionUsage", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final UsageDescriptor getJRETypeUsage(@NotNull String key, @Nullable String jreName) {
            CharSequence charSequence = jreName;
            String anonymizedName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "empty" : (CollectionsKt.listOf((Object[])new String[]{"#JAVA_INTERNAL", "#USE_PROJECT_JDK", "#JAVA_HOME"}).contains(jreName) ? jreName : "custom");
            return new UsageDescriptor(key + '.' + anonymizedName, 1);
        }

        @NotNull
        public final UsageDescriptor getJREVersionUsage(@NotNull Project project, @NotNull String key, @Nullable String jreName) {
            Object object;
            block6: {
                block5: {
                    String string;
                    Object object2;
                    Sdk jdk = ExternalSystemJdkUtil.getJdk(project, jreName);
                    object = jdk;
                    if (object == null || (object = object.getVersionString()) == null) break block5;
                    Object it = object2 = object;
                    boolean bl = false;
                    Version version = Version.parseVersion((String)it);
                    if (version != null) {
                        Version version2;
                        Version parsed = version2 = version;
                        boolean bl2 = false;
                        string = "" + parsed.major + '.' + parsed.minor;
                    } else {
                        string = object = null;
                    }
                    if (string != null) break block6;
                }
                object = "unknown";
            }
            Object versionString = object;
            return new UsageDescriptor(key + '.' + (String)versionString, 1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

