/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantApps;
import com.google.urlassistant.AppLinkTableCell;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Order
implements AppLinkTableCell {
    public static final Order DEFAULT_INSTANCE = new Order(null);
    private static Predicate<Project> ourSupportedOverride;
    private Integer myOrder;

    public Order(@Nullable Integer order) {
        this.myOrder = order;
    }

    public void setOrder(@Nullable Integer order) {
        this.myOrder = order;
    }

    @Override
    @NotNull
    public String getHtmlText(boolean isSelected) {
        return this.myOrder == null ? AppLinkTableCell.generateHtmlText("0", "default", isSelected) : this.myOrder.toString();
    }

    public int getIntValue() {
        return this.myOrder == null ? 0 : this.myOrder;
    }

    @Nullable
    public Integer getInteger() {
        return this.myOrder;
    }

    public static boolean isSupportedFor(@NotNull Project project) {
        Module[] modules;
        if (ourSupportedOverride != null) {
            return ourSupportedOverride.apply((Object)project);
        }
        if (InstantApps.findBaseFeature((Project)project) != null) {
            return true;
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get((Module)module);
            if (androidModuleModel == null || androidModuleModel.getTargetSdkVersion() == null || androidModuleModel.getTargetSdkVersion().getFeatureLevel() < 26) continue;
            return true;
        }
        return false;
    }

    public static void setSupportedOverride(@Nullable Predicate<Project> supportedOverride) {
        ourSupportedOverride = supportedOverride;
    }

    public String toString() {
        return this.myOrder == null ? "0 (default)" : this.myOrder.toString();
    }
}

