/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class Sha256FingerprintUtils {
    private static Logger getLog() {
        return Logger.getInstance(Sha256FingerprintUtils.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<String> getAliases(String filePath) {
        try (FileInputStream is = new FileInputStream(filePath);){
            ArrayList<String> aliases = new ArrayList<String>();
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, null);
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                aliases.add(e.nextElement());
            }
            ArrayList<String> arrayList = aliases;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            Sha256FingerprintUtils.getLog().warn("Cannot find the keystore file.");
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
            return Collections.emptyList();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String generateFingerprints(String filePath, String alias) {
        try (FileInputStream is = new FileInputStream(filePath);){
            Certificate certificate;
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, null);
            if (alias == null) {
                alias = keystore.aliases().nextElement();
            }
            if ((certificate = keystore.getCertificate(alias)) == null) {
                throw new KeyStoreException("No such alias in keystore");
            }
            byte[] encCertInfo = certificate.getEncoded();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(encCertInfo);
            String string = Sha256FingerprintUtils.toHexString(digest);
            return string;
        }
        catch (FileNotFoundException e) {
            Sha256FingerprintUtils.getLog().warn("Cannot find the keystore file.");
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
            return "";
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        return "";
    }

    @NotNull
    public static String toHexString(@NotNull byte[] array) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : array) {
            builder.append(String.format("%02x", b));
            builder.append(":");
        }
        return builder.deleteCharAt(builder.length() - 1).toString().toUpperCase(Locale.US);
    }
}

