/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import org.jetbrains.annotations.Nullable;

public enum ExternalSystemSourceType implements IExternalSystemSourceType
{
    SOURCE(false, false, false, false),
    TEST(true, false, false, false),
    EXCLUDED(false, false, false, true),
    SOURCE_GENERATED(false, true, false, false),
    TEST_GENERATED(true, true, false, false),
    RESOURCE(false, false, true, false),
    TEST_RESOURCE(true, false, true, false);

    private final boolean isTest;
    private final boolean isGenerated;
    private final boolean isResource;
    private final boolean isExcluded;

    private ExternalSystemSourceType(boolean test, boolean generated, boolean resource, boolean excluded) {
        this.isTest = test;
        this.isGenerated = generated;
        this.isResource = resource;
        this.isExcluded = excluded;
    }

    @Override
    public boolean isTest() {
        return this.isTest;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public boolean isResource() {
        return this.isResource;
    }

    @Override
    public boolean isExcluded() {
        return this.isExcluded;
    }

    public static ExternalSystemSourceType from(IExternalSystemSourceType sourceType) {
        for (ExternalSystemSourceType systemSourceType : ExternalSystemSourceType.values()) {
            if (systemSourceType.isGenerated != sourceType.isGenerated() || systemSourceType.isResource != sourceType.isResource() || systemSourceType.isTest != sourceType.isTest() || systemSourceType.isExcluded != sourceType.isExcluded()) continue;
            return systemSourceType;
        }
        throw new IllegalArgumentException("Invalid source type: " + sourceType);
    }

    @Nullable
    public static ExternalSystemSourceType from(boolean isTest, boolean isGenerated, boolean isResource, boolean isExcluded) {
        for (ExternalSystemSourceType systemSourceType : ExternalSystemSourceType.values()) {
            if (systemSourceType.isGenerated != isGenerated || systemSourceType.isResource != isResource || systemSourceType.isTest != isTest || systemSourceType.isExcluded != isExcluded) continue;
            return systemSourceType;
        }
        return null;
    }
}

