/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangesDiffCalculator {
    private static final Logger LOG = Logger.getInstance(ChangesDiffCalculator.class);

    public static List<TextRange> calculateDiff(@NotNull Document beforeDocument, @NotNull Document currentDocument) {
        CharSequence beforeText = beforeDocument.getCharsSequence();
        CharSequence currentText = currentDocument.getCharsSequence();
        try {
            ComparisonManager manager = ComparisonManager.getInstance();
            List lineFragments = manager.compareLinesInner(beforeText, currentText, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            ArrayList<TextRange> modifiedRanges = new ArrayList<TextRange>();
            for (LineFragment lineFragment : lineFragments) {
                int fragmentStartOffset = lineFragment.getStartOffset2();
                int fragmentEndOffset = lineFragment.getEndOffset2();
                List innerFragments = lineFragment.getInnerFragments();
                if (innerFragments != null) {
                    for (DiffFragment innerFragment : innerFragments) {
                        int innerFragmentStartOffset = fragmentStartOffset + innerFragment.getStartOffset2();
                        int innerFragmentEndOffset = fragmentStartOffset + innerFragment.getEndOffset2();
                        modifiedRanges.add(ChangesDiffCalculator.calculateChangeHighlightRange(currentText, innerFragmentStartOffset, innerFragmentEndOffset));
                    }
                    continue;
                }
                modifiedRanges.add(ChangesDiffCalculator.calculateChangeHighlightRange(currentText, fragmentStartOffset, fragmentEndOffset));
            }
            return modifiedRanges;
        }
        catch (DiffTooBigException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private static TextRange calculateChangeHighlightRange(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            while (startOffset < text.length() && text.charAt(startOffset) == ' ') {
                ++startOffset;
            }
            return new TextRange(startOffset, startOffset);
        }
        int originalStartOffset = startOffset;
        int originalEndOffset = endOffset;
        while (endOffset < text.length() && ChangesDiffCalculator.rangesEqual(text, originalStartOffset, originalEndOffset, startOffset + 1, endOffset + 1)) {
            ++startOffset;
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean rangesEqual(@NotNull CharSequence text, int start1, int end1, int start2, int end2) {
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = start1; i < end1; ++i) {
            if (text.charAt(i) == text.charAt(i - start1 + start2)) continue;
            return false;
        }
        return true;
    }
}

