/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeCompletionConfigurableEP;
import com.intellij.application.options.CodeCompletionOptionsCustomSection;
import com.intellij.application.options.CodeCompletionPanel;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CodeCompletionOptions
extends CompositeConfigurable<UnnamedConfigurable>
implements EditorOptionsProvider {
    private static final ExtensionPointName<CodeCompletionConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.codeCompletionConfigurable");
    private CodeCompletionPanel myPanel;

    @Override
    public boolean isModified() {
        return super.isModified() || this.myPanel != null && this.myPanel.isModified();
    }

    public JComponent createComponent() {
        List configurables = this.getConfigurables();
        ArrayList addonComponents = ContainerUtil.newArrayListWithCapacity((int)configurables.size());
        ArrayList sectionComponents = ContainerUtil.newArrayListWithCapacity((int)configurables.size());
        for (UnnamedConfigurable configurable : configurables) {
            if (configurable instanceof CodeCompletionOptionsCustomSection) {
                sectionComponents.add(configurable.createComponent());
                continue;
            }
            addonComponents.add(configurable.createComponent());
        }
        this.myPanel = new CodeCompletionPanel(addonComponents, sectionComponents);
        return this.myPanel.myPanel;
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.completion", (Object[])new Object[0]);
    }

    @Override
    public void reset() {
        super.reset();
        this.myPanel.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        this.myPanel.apply();
    }

    @Override
    public void disposeUIResources() {
        this.myPanel = null;
        super.disposeUIResources();
    }

    @Override
    @NotNull
    protected List<UnnamedConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(EP_NAME);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.code.completion";
    }

    @NotNull
    public String getId() {
        return "editor.preferences.completion";
    }
}

