/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ChangesDiffCalculator;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.ide.ui.search.ComponentHighligtingListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleAbstractPanel
implements Disposable,
ComponentHighligtingListener {
    private static final long TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleXmlPanel");
    private final List<TextRange> myPreviewRangesToHighlight = new ArrayList<TextRange>();
    private final EditorEx myEditor;
    private final CodeStyleSettings mySettings;
    private boolean myShouldUpdatePreview;
    protected static final int[] ourWrappings = new int[]{0, 1, 4, 2};
    private long myLastDocumentModificationStamp;
    private String myTextToReformat;
    private final UserActivityWatcher myUserActivityWatcher = new UserActivityWatcher();
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    @Nullable
    private CodeStyleSchemesModel myModel;
    private boolean mySomethingChanged;
    private long myEndHighlightPreviewChangesTimeMillis = -1L;
    private boolean myShowsPreviewHighlighters;
    private final CodeStyleSettings myCurrentSettings;
    private final Language myDefaultLanguage;
    private Document myDocumentBeforeChanges;

    protected CodeStyleAbstractPanel(@NotNull CodeStyleSettings settings) {
        this(null, null, settings);
    }

    protected CodeStyleAbstractPanel(@Nullable Language defaultLanguage, @Nullable CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        this.myCurrentSettings = currentSettings;
        this.mySettings = settings;
        this.myDefaultLanguage = defaultLanguage;
        this.myEditor = this.createEditor();
        if (this.myEditor != null) {
            this.myUpdateAlarm.setActivationComponent(this.myEditor.getComponent());
        }
        this.myUserActivityWatcher.addUserActivityListener(() -> this.somethingChanged());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ComponentHighligtingListener.TOPIC, (Object)this);
        this.updatePreview(true);
    }

    protected void setShouldUpdatePreview(boolean shouldUpdatePreview) {
        this.myShouldUpdatePreview = shouldUpdatePreview;
    }

    private synchronized void setSomethingChanged(boolean b) {
        this.mySomethingChanged = b;
    }

    private synchronized boolean isSomethingChanged() {
        return this.mySomethingChanged;
    }

    public void setModel(@NotNull CodeStyleSchemesModel model) {
        this.myModel = model;
    }

    protected void somethingChanged() {
        if (this.myModel != null) {
            this.myModel.fireBeforeCurrentSettingsChanged();
        }
    }

    protected void addPanelToWatch(Component component) {
        this.myUserActivityWatcher.register(component);
    }

    @Nullable
    private EditorEx createEditor() {
        if (StringUtil.isEmpty((String)this.getPreviewText())) {
            return null;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        CodeStyleAbstractPanel.fillEditorSettings(editor.getSettings());
        this.myLastDocumentModificationStamp = editor.getDocument().getModificationStamp();
        return editor;
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(true);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
        editorSettings.setSoftMargins(Collections.emptyList());
    }

    protected void updatePreview(boolean useDefaultSample) {
        if (this.myEditor == null) {
            return;
        }
        this.updateEditor(useDefaultSample);
        this.updatePreviewHighlighter(this.myEditor);
    }

    private void updateEditor(boolean useDefaultSample) {
        if (!this.myShouldUpdatePreview || !ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (this.myEditor.isDisposed()) {
            return;
        }
        if (this.myLastDocumentModificationStamp != this.myEditor.getDocument().getModificationStamp()) {
            this.myTextToReformat = this.myEditor.getDocument().getText();
        } else if (useDefaultSample || this.myTextToReformat == null) {
            this.myTextToReformat = StringUtil.convertLineSeparators((String)((String)ObjectUtils.notNull((Object)this.getPreviewText(), (Object)"")));
        }
        this.updateEditorState(true);
    }

    protected void setEditorText(@NotNull String text, boolean updateHighlighter) {
        this.myTextToReformat = StringUtil.convertLineSeparators((String)text);
        if (updateHighlighter) {
            this.updatePreviewHighlighter(this.myEditor);
        }
        this.updateEditorState(false);
    }

    private void updateEditorState(boolean collectChanges) {
        int currOffs = this.myEditor.getScrollingModel().getVerticalScrollOffset();
        Project project = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CommandProcessor.getInstance().executeCommand(project, () -> this.replaceText(project, collectChanges), null, null);
        this.myEditor.getSettings().setRightMargin(this.getAdjustedRightMargin());
        this.myLastDocumentModificationStamp = this.myEditor.getDocument().getModificationStamp();
        this.myEditor.getScrollingModel().scrollVertically(currOffs);
    }

    private int getAdjustedRightMargin() {
        int result2 = this.getRightMargin();
        return result2 > 0 ? result2 : CodeStyle.getSettings((Project)ProjectUtil.guessCurrentProject((JComponent)this.getPanel())).getRightMargin(this.getDefaultLanguage());
    }

    protected abstract int getRightMargin();

    private void replaceText(Project project, boolean collectChanges) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Document beforeReformat = null;
                if (collectChanges && this.myEditor.getDocument().getTextLength() > 0) {
                    beforeReformat = this.collectChangesBeforeCurrentSettingsAppliance(project);
                }
                PsiFile psiFile = this.createFileFromText(project, this.myTextToReformat);
                this.prepareForReformat(psiFile);
                this.applySettingsToModel();
                CodeStyleSettings clone = this.mySettings.clone();
                clone.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
                Ref formatted = Ref.create();
                CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)clone, () -> formatted.set((Object)this.doReformat(project, psiFile)));
                this.myEditor.getSettings().setTabSize(clone.getTabSize(this.getFileType()));
                DocumentEx document = this.myEditor.getDocument();
                document.replaceString(0, document.getTextLength(), ((PsiFile)formatted.get()).getText());
                if (beforeReformat != null) {
                    this.highlightChanges(beforeReformat);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private void applySettingsToModel() {
        if (this.mySettings instanceof CodeStyleSchemesModel.ModelSettings && ((CodeStyleSchemesModel.ModelSettings)this.mySettings).isLocked()) {
            return;
        }
        try {
            if (this.myModel != null && this.myModel.isUiEventsEnabled()) {
                this.apply(this.mySettings);
                this.myModel.fireAfterCurrentSettingsChanged();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Nullable
    private Document collectChangesBeforeCurrentSettingsAppliance(Project project) {
        PsiFile psiFile = this.createFileFromText(project, this.myTextToReformat);
        this.prepareForReformat(psiFile);
        CodeStyleSettings clone = this.mySettings.clone();
        clone.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
        CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)clone, () -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile));
        return this.getDocumentBeforeChanges(project, psiFile);
    }

    private Document getDocumentBeforeChanges(@NotNull Project project, @NotNull PsiFile file2) {
        Document document;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (documentManager != null && (document = documentManager.getDocument(file2)) != null) {
            return document;
        }
        if (this.myDocumentBeforeChanges == null) {
            this.myDocumentBeforeChanges = new DocumentImpl(file2.getText());
        } else {
            this.myDocumentBeforeChanges.replaceString(0, this.myDocumentBeforeChanges.getTextLength(), (CharSequence)file2.getText());
        }
        return this.myDocumentBeforeChanges;
    }

    protected void prepareForReformat(PsiFile psiFile) {
    }

    protected String getFileExt() {
        return this.getFileTypeExtension(this.getFileType());
    }

    @Deprecated
    protected PsiFile createFileFromText(Project project, String text) {
        PsiFile file2;
        LanguageCodeStyleSettingsProvider provider;
        Language language = this.getDefaultLanguage();
        if (language != null && (provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null && (file2 = provider.createFileFromText(project, text)) != null) {
            if (file2.isPhysical()) {
                LOG.error(provider.getClass() + " creates a physical file with PSI events enabled");
            }
            return file2;
        }
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a." + this.getFileExt(), this.getFileType(), (CharSequence)text, LocalTimeCounter.currentTime(), false);
    }

    protected PsiFile doReformat(Project project, PsiFile psiFile) {
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        return psiFile;
    }

    private void highlightChanges(Document beforeReformat) {
        this.myPreviewRangesToHighlight.clear();
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        markupModel.removeAllHighlighters();
        this.myPreviewRangesToHighlight.addAll(ChangesDiffCalculator.calculateDiff(beforeReformat, this.myEditor.getDocument()));
        if (!this.myPreviewRangesToHighlight.isEmpty()) {
            this.myEndHighlightPreviewChangesTimeMillis = System.currentTimeMillis() + TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS;
            this.myShowsPreviewHighlighters = true;
        }
    }

    private static boolean isWithinBounds(VisualPosition targetPosition, VisualPosition startPosition, VisualPosition endPosition) {
        return targetPosition.line >= startPosition.line && targetPosition.line <= endPosition.line && targetPosition.column >= startPosition.column && targetPosition.column <= endPosition.column;
    }

    private void updatePreviewHighlighter(EditorEx editor) {
        EditorColorsScheme scheme2 = editor.getColorsScheme();
        editor.getSettings().setCaretRowShown(false);
        EditorHighlighter highlighter = this.createHighlighter(scheme2);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        } else {
            LOG.warn("No highlighter for " + this.getDefaultLanguage());
        }
    }

    @Nullable
    protected abstract EditorHighlighter createHighlighter(EditorColorsScheme var1);

    @NotNull
    protected abstract FileType getFileType();

    @NonNls
    @Nullable
    protected abstract String getPreviewText();

    public abstract void apply(CodeStyleSettings var1) throws ConfigurationException;

    public final void reset(CodeStyleSettings settings) {
        this.myShouldUpdatePreview = false;
        try {
            this.resetImpl(settings);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myShouldUpdatePreview = true;
        }
    }

    protected static int getIndexForWrapping(int value) {
        for (int i = 0; i < ourWrappings.length; ++i) {
            int ourWrapping = ourWrappings[i];
            if (ourWrapping != value) continue;
            return i;
        }
        LOG.error("Invalid wrapping option index: " + value);
        return 0;
    }

    public abstract boolean isModified(CodeStyleSettings var1);

    @Nullable
    public abstract JComponent getPanel();

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
    }

    protected abstract void resetImpl(CodeStyleSettings var1);

    protected static void fillWrappingCombo(JComboBox wrapCombo) {
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.do.not.wrap", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.wrap.if.long", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.chop.down.if.long", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.wrap.always", (Object[])new Object[0]));
    }

    /*
     * Exception decompiling
     */
    public static String readFromFile(Class resourceContainerClass, @NonNls String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void installPreviewPanel(JPanel previewPanel) {
        previewPanel.setLayout(new BorderLayout());
        previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        previewPanel.setBorder(new AbstractBorder(){
            private static final int LEFT_WHITE_SPACE = 2;

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Editor editor = CodeStyleAbstractPanel.this.getEditor();
                if (editor instanceof EditorEx) {
                    g.setColor(((EditorEx)editor).getBackgroundColor());
                    g.fillRect(x + 1, y, 2, height);
                }
                g.setColor(OnePixelDivider.BACKGROUND);
                g.fillRect(x, y, 1, height);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.set(0, 3, 0, 0);
                return insets;
            }
        });
    }

    @NonNls
    protected String getFileTypeExtension(FileType fileType) {
        return fileType.getDefaultExtension();
    }

    public void onSomethingChanged() {
        this.setSomethingChanged(true);
        if (this.myEditor != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.updateEditor(true);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), () -> this.addUpdatePreviewRequest());
            }
        } else {
            this.applySettingsToModel();
        }
    }

    private void addUpdatePreviewRequest() {
        this.myUpdateAlarm.addComponentRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CodeStyleAbstractPanel.this.myUpdateAlarm.cancelAllRequests();
                    if (CodeStyleAbstractPanel.this.isSomethingChanged()) {
                        CodeStyleAbstractPanel.this.updateEditor(false);
                    }
                    if (System.currentTimeMillis() <= CodeStyleAbstractPanel.this.myEndHighlightPreviewChangesTimeMillis && !CodeStyleAbstractPanel.this.myPreviewRangesToHighlight.isEmpty()) {
                        CodeStyleAbstractPanel.this.blinkHighlighters();
                        CodeStyleAbstractPanel.this.myUpdateAlarm.addComponentRequest((Runnable)this, 500);
                    } else {
                        CodeStyleAbstractPanel.this.myEditor.getMarkupModel().removeAllHighlighters();
                    }
                }
                finally {
                    CodeStyleAbstractPanel.this.setSomethingChanged(false);
                }
            }
        }, 300);
    }

    private void blinkHighlighters() {
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        if (this.myShowsPreviewHighlighters) {
            Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
            VisualPosition visualStart = this.myEditor.xyToVisualPosition(visibleArea.getLocation());
            VisualPosition visualEnd = this.myEditor.xyToVisualPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
            int endColumnCandidate = visibleArea.width / EditorUtil.getSpaceWidth(0, this.myEditor) + visualStart.column;
            if (endColumnCandidate > visualEnd.column) {
                visualEnd = new VisualPosition(visualEnd.line, endColumnCandidate);
            }
            int offsetToScroll = -1;
            CharSequence text = this.myEditor.getDocument().getCharsSequence();
            TextAttributes backgroundAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextAttributes borderAttributes = new TextAttributes(null, null, backgroundAttributes.getBackgroundColor(), EffectType.BOXED, 0);
            boolean scrollToChange = true;
            for (TextRange range2 : this.myPreviewRangesToHighlight) {
                if (scrollToChange) {
                    boolean rangeVisible = CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range2.getStartOffset()), visualStart, visualEnd) || CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range2.getEndOffset()), visualStart, visualEnd);
                    boolean bl = scrollToChange = !rangeVisible;
                    if (offsetToScroll < 0) {
                        if (text.charAt(range2.getStartOffset()) != '\n') {
                            offsetToScroll = range2.getStartOffset();
                        } else if (range2.getEndOffset() > 0 && text.charAt(range2.getEndOffset() - 1) != '\n') {
                            offsetToScroll = range2.getEndOffset() - 1;
                        }
                    }
                }
                TextAttributes attributesToUse = range2.getLength() > 0 ? backgroundAttributes : borderAttributes;
                markupModel.addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 6000, attributesToUse, HighlighterTargetArea.EXACT_RANGE);
            }
            if (scrollToChange) {
                if (offsetToScroll < 0 && !this.myPreviewRangesToHighlight.isEmpty()) {
                    offsetToScroll = this.myPreviewRangesToHighlight.get(0).getStartOffset();
                }
                if (offsetToScroll >= 0 && offsetToScroll < text.length() - 1 && text.charAt(offsetToScroll) != '\n') {
                    ++offsetToScroll;
                }
                if (offsetToScroll >= 0 && offsetToScroll < this.myEditor.getDocument().getTextLength()) {
                    this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offsetToScroll), ScrollType.RELATIVE);
                }
            }
        } else {
            markupModel.removeAllHighlighters();
        }
        this.myShowsPreviewHighlighters = !this.myShowsPreviewHighlighters;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public Set<String> processListOptions() {
        return Collections.emptySet();
    }

    public final void applyPredefinedSettings(@NotNull PredefinedCodeStyle codeStyle) {
        codeStyle.apply(this.mySettings);
        ((CodeStyleSchemesModel.ModelSettings)this.mySettings).doWithLockedSettings(() -> this.resetImpl(this.mySettings));
        if (this.myModel != null) {
            this.myModel.fireAfterCurrentSettingsChanged();
        }
    }

    @Nullable
    public Language getDefaultLanguage() {
        return this.myDefaultLanguage;
    }

    protected String getTabTitle() {
        return "Other";
    }

    protected CodeStyleSettings getCurrentSettings() {
        return this.myCurrentSettings;
    }

    @Nullable
    protected CodeStyleSettings getModelSettings() {
        CodeStyleSchemesModel model = this.myModel;
        return model != null ? model.getCloneSettings(model.getSelectedScheme()) : null;
    }

    public void setupCopyFromMenu(JPopupMenu copyMenu) {
        copyMenu.removeAll();
    }

    @Deprecated
    public boolean isCopyFromMenuAvailable() {
        return false;
    }

    @Override
    public final void highlight(@NotNull JComponent component, @NotNull String searchString) {
        if (this.isInsideThisPanel(component)) {
            if (component instanceof TabLabel) {
                Container parent = component.getParent();
                if (parent instanceof JBTabs) {
                    ((JBTabs)parent).select(((TabLabel)component).getInfo(), false);
                }
            } else {
                JTabbedPane tabbedPane;
                int index;
                JPanel tabPanel = CodeStyleAbstractPanel.findTabbedPaneChild(component);
                if (tabPanel != null && (index = (tabbedPane = (JTabbedPane)tabPanel.getParent()).indexOfComponent(tabPanel)) >= 0) {
                    tabbedPane.setSelectedIndex(index);
                }
            }
        }
    }

    @Nullable
    private static JPanel findTabbedPaneChild(@NotNull JComponent component) {
        Container parent = component.getParent();
        while (parent != null && !(parent instanceof NewCodeStyleSettingsPanel)) {
            Container nextParent = parent.getParent();
            if (nextParent instanceof JTabbedPane && parent instanceof JPanel) {
                return (JPanel)parent;
            }
            parent = nextParent;
        }
        return null;
    }

    private boolean isInsideThisPanel(@NotNull JComponent rootComponent) {
        JComponent thisPanel = this.getPanel();
        for (Container parent = rootComponent.getParent(); parent != null && !(parent instanceof NewCodeStyleSettingsPanel); parent = parent.getParent()) {
            if (parent != thisPanel) continue;
            return true;
        }
        return false;
    }
}

