/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(value="path.macros.xml", roamingType=RoamingType.PER_OS)})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element>,
ModificationTracker {
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    public static final String MAVEN_REPOSITORY = "MAVEN_REPOSITORY";
    private static final Logger LOG = Logger.getInstance(PathMacrosImpl.class);
    private static final Set<String> SYSTEM_MACROS = new THashSet();
    private final Map<String, String> myLegacyMacros = new THashMap();
    private final Map<String, String> myMacros = new LinkedHashMap();
    private long myModificationStamp = 0L;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final List<String> myIgnoredMacros = ContainerUtil.createLockFreeCopyOnWriteList();
    private final AtomicClearableLazyValue<Map<String, String>> myUserMacroMapCache = new AtomicClearableLazyValue<Map<String, String>>(){

        @NotNull
        protected Map<String, String> compute() {
            PathMacrosImpl.this.myLock.readLock().lock();
            try {
                if (PathMacrosImpl.this.myMacros.isEmpty()) {
                    Map<String, String> map2 = Collections.emptyMap();
                    return map2;
                }
                LinkedHashMap result2 = new LinkedHashMap();
                result2.putAll(PathMacrosImpl.this.myMacros);
                Map<String, String> map3 = Collections.unmodifiableMap(result2);
                return map3;
            }
            finally {
                PathMacrosImpl.this.myLock.readLock().unlock();
            }
        }
    };

    public static PathMacrosImpl getInstanceEx() {
        return (PathMacrosImpl)PathMacrosImpl.getInstance();
    }

    @NotNull
    public Set<String> getUserMacroNames() {
        return ((Map)this.myUserMacroMapCache.getValue()).keySet();
    }

    @NotNull
    public Map<String, String> getUserMacros() {
        return (Map)this.myUserMacroMapCache.getValue();
    }

    @NotNull
    public Set<String> getToolMacroNames() {
        return Collections.emptySet();
    }

    @NotNull
    public Set<String> getSystemMacroNames() {
        return SYSTEM_MACROS;
    }

    @NotNull
    public Collection<String> getIgnoredMacroNames() {
        return this.myIgnoredMacros;
    }

    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        try {
            this.myLock.writeLock().lock();
            this.myIgnoredMacros.clear();
            this.myIgnoredMacros.addAll(names);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void addIgnoredMacro(@NotNull String name) {
        if (!this.myIgnoredMacros.contains(name)) {
            this.myIgnoredMacros.add(name);
        }
    }

    public long getModificationCount() {
        this.myLock.readLock().lock();
        try {
            long l = this.myModificationStamp;
            return l;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public boolean isIgnoredMacroName(@NotNull String macro) {
        return this.myIgnoredMacros.contains(macro);
    }

    @NotNull
    public Set<String> getAllMacroNames() {
        return ContainerUtil.union(this.getUserMacroNames(), this.getSystemMacroNames());
    }

    @Nullable
    public String getValue(@NotNull String name) {
        try {
            this.myLock.readLock().lock();
            String string = this.myMacros.get(name);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public void removeAllMacros() {
        try {
            this.myLock.writeLock().lock();
            this.myMacros.clear();
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @NotNull
    public Collection<String> getLegacyMacroNames() {
        try {
            this.myLock.readLock().lock();
            THashSet tHashSet = new THashSet(this.myLegacyMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMacro(@NotNull String name, @Nullable String value) {
        try {
            this.myLock.writeLock().lock();
            if (StringUtil.isEmptyOrSpaces((String)value)) {
                if (this.myMacros.remove(name) != null) {
                    this.userMacroModified();
                }
                return;
            }
            String prevValue = this.myMacros.put(name, value);
            if (!value.equals(prevValue)) {
                this.userMacroModified();
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private void userMacroModified() {
        ++this.myModificationStamp;
        this.myUserMacroMapCache.drop();
    }

    public void addLegacyMacro(@NotNull String name, @NotNull String value) {
        try {
            this.myLock.writeLock().lock();
            this.myLegacyMacros.put(name, value);
            this.myMacros.remove(name);
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void removeMacro(@NotNull String name) {
        try {
            this.myLock.writeLock().lock();
            LOG.assertTrue(this.myMacros.remove(name) != null);
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state");
            this.myLock.readLock().lock();
            for (Map.Entry<String, String> entry : this.myMacros.entrySet()) {
                String value = entry.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                Element macro = new Element("macro");
                macro.setAttribute("name", entry.getKey());
                macro.setAttribute("value", value);
                element.addContent(macro);
            }
            for (String macro : this.myIgnoredMacros) {
                Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
                macroElement.setAttribute("name", macro);
                element.addContent(macroElement);
            }
            Iterator<Object> iterator = element;
            return iterator;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        try {
            this.myLock.writeLock().lock();
            for (Element macro : element.getChildren("macro")) {
                String name = macro.getAttributeValue("name");
                String value = macro.getAttributeValue("value");
                if (name == null || value == null || SYSTEM_MACROS.contains(name)) continue;
                if (value.length() > 1 && value.charAt(value.length() - 1) == '/') {
                    value = value.substring(0, value.length() - 1);
                }
                this.myMacros.put(name, value);
            }
            for (Element macroElement : element.getChildren(IGNORED_MACRO_ELEMENT)) {
                String ignoredName = macroElement.getAttributeValue("name");
                if (StringUtil.isEmpty((String)ignoredName) || this.myIgnoredMacros.contains(ignoredName)) continue;
                this.myIgnoredMacros.add(ignoredName);
            }
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void addMacroReplacements(@NotNull ReplacePathToMacroMap result2) {
        Map<String, String> userMacros = this.getUserMacros();
        for (String name : userMacros.keySet()) {
            String value = userMacros.get(name);
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            result2.addMacroReplacement(value, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacroExpands(@NotNull ExpandMacroToPathMap result2) {
        Map<String, String> userMacros = this.getUserMacros();
        for (String string : userMacros.keySet()) {
            String value = userMacros.get(string);
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            result2.addMacroExpand(string, value);
        }
        this.myLock.readLock().lock();
        try {
            for (Map.Entry entry : this.myLegacyMacros.entrySet()) {
                result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    static {
        SYSTEM_MACROS.add("APPLICATION_HOME_DIR");
        SYSTEM_MACROS.add("APPLICATION_PLUGINS_DIR");
        SYSTEM_MACROS.add("PROJECT_DIR");
        SYSTEM_MACROS.add("MODULE_WORKING_DIR");
        SYSTEM_MACROS.add("MODULE_DIR");
        SYSTEM_MACROS.add("USER_HOME");
    }
}

