/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private final Map<String, String> myMacroMap = new LinkedHashMap();
    @NonNls
    public static final String[] PROTOCOLS;

    public ReplacePathToMacroMap() {
    }

    public ReplacePathToMacroMap(@NotNull ReplacePathToMacroMap map2) {
        this.myMacroMap.putAll(map2.myMacroMap);
    }

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtil.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        this.putIfAbsent(path, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    public String substitute(@Nullable String text, boolean caseSensitive) {
        if (text == null) {
            return null;
        }
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacro(text, path, caseSensitive);
        }
        return text;
    }

    private String replacePathMacro(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        if (!(!caseSensitive ? StringUtilRt.startsWithIgnoreCase((String)text, (String)path) : text.startsWith(path))) {
            return text;
        }
        int endOfOccurrence = path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!(isWindowsRoot || endOfOccurrence >= text.length() || text.charAt(endOfOccurrence) == '/' || text.charAt(endOfOccurrence) == '!' && text.substring(endOfOccurrence).startsWith("!/"))) {
            return text;
        }
        String s = this.myMacroMap.get(path);
        if (text.length() > endOfOccurrence) {
            return s + text.substring(endOfOccurrence);
        }
        return s;
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        CharSequence result2 = text;
        for (String path : this.getPathIndex()) {
            result2 = this.replacePathMacroRecursively(result2, path, caseSensitive);
        }
        return result2.toString();
    }

    private CharSequence replacePathMacroRecursively(@NotNull CharSequence text, @NotNull String path, boolean caseSensitive) {
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i = 0;
        while (i < text.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? StringUtil.indexOf((CharSequence)text, (CharSequence)path, (int)i) : StringUtil.indexOfIgnoreCase((CharSequence)text, (CharSequence)path, (int)i);
            if (occurrenceOfPath >= 0) {
                char prev2;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && text.charAt(endOfOccurrence) != '\"' && text.charAt(endOfOccurrence) != ' ' && !StringUtil.startsWith((CharSequence)text, (int)endOfOccurrence, (CharSequence)"!/")) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev2 = text.charAt(occurrenceOfPath - 1)) || prev2 == '_')) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            newText.append(text, i, occurrenceOfPath);
            newText.append(this.myMacroMap.get(path));
            i = occurrenceOfPath + path.length();
        }
        return newText;
    }

    private static int getIndex(@NotNull String replacement) {
        if (replacement.contains("..") || replacement.contains("$USER_HOME$") || replacement.contains("$APPLICATION_HOME_DIR$") || replacement.contains("$MAVEN_REPOSITORY$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$") || replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        key = StringUtil.trimStart((String)key, (String)"jar:");
        key = StringUtil.trimStart((String)key, (String)"file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    private List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.myMacroMap.size()) {
            ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
            TObjectIntHashMap weights = new TObjectIntHashMap(entries2.size());
            for (Map.Entry entry2 : entries2) {
                weights.put(entry2.getKey(), ReplacePathToMacroMap.getIndex((String)entry2.getValue()) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
            }
            entries2.sort((o1, o2) -> weights.get(o2.getKey()) - weights.get(o1.getKey()));
            this.myPathsIndex = ContainerUtilRt.map2List(entries2, entry -> (String)entry.getKey());
        }
        return this.myPathsIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    public String toString() {
        return "macroMap: " + this.myMacroMap + "\n\npathsIndex: " + StringUtil.join(this.myPathsIndex, (String)"\n");
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (Extensions.getRootArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME)) {
            for (PathMacroExpandableProtocolBean bean : PathMacroExpandableProtocolBean.EP_NAME.getExtensionList()) {
                protocols.add(bean.protocol);
            }
        }
        PROTOCOLS = ArrayUtil.toStringArray(protocols);
    }
}

