/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleBlankLinesPanel
extends CustomizableLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.codeStyle.CodeStyleBlankLinesPanel");
    private final List<IntOption> myOptions = new ArrayList<IntOption>();
    private final Set<String> myAllowedOptions = new HashSet<String>();
    private boolean myAllOptionsAllowed = false;
    private boolean myIsFirstUpdate = true;
    private final Map<String, String> myRenamedFields = new THashMap();
    private final MultiMap<String, Trinity<Class<? extends CustomCodeStyleSettings>, String, String>> myCustomOptions = new MultiMap();
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public CodeStyleBlankLinesPanel(CodeStyleSettings settings) {
        super(settings);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        Map settings = CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
        OptionGroup keepBlankLinesOptionsGroup = this.createOptionsGroup(BLANK_LINES_KEEP, (List)settings.get(new CodeStyleSettingPresentation.SettingsGroup(BLANK_LINES_KEEP)));
        OptionGroup blankLinesOptionsGroup = this.createOptionsGroup(BLANK_LINES, (List)settings.get(new CodeStyleSettingPresentation.SettingsGroup(BLANK_LINES)));
        if (keepBlankLinesOptionsGroup != null) {
            keepBlankLinesOptionsGroup.setAnchor(keepBlankLinesOptionsGroup.findAnchor());
            optionsPanel.add((Component)keepBlankLinesOptionsGroup.createPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        if (blankLinesOptionsGroup != null) {
            blankLinesOptionsGroup.setAnchor(blankLinesOptionsGroup.findAnchor());
            optionsPanel.add((Component)blankLinesOptionsGroup.createPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{keepBlankLinesOptionsGroup, blankLinesOptionsGroup});
        optionsPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        optionsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)optionsPanel, (boolean)true);
        scroll.setMinimumSize(new Dimension(optionsPanel.getPreferredSize().width + scroll.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        scroll.setPreferredSize(scroll.getMinimumSize());
        this.myPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel previewPanel = CodeStyleBlankLinesPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.myIsFirstUpdate = false;
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS;
    }

    @Nullable
    private OptionGroup createOptionsGroup(@NotNull String groupName, @NotNull List<CodeStyleSettingPresentation> settings) {
        OptionGroup optionGroup = new OptionGroup(groupName);
        for (CodeStyleSettingPresentation setting : settings) {
            this.createOption(optionGroup, setting.getUiName(), setting.getFieldName());
        }
        this.initCustomOptions(optionGroup, groupName);
        if (optionGroup.getComponents().length == 0) {
            return null;
        }
        return optionGroup;
    }

    private void initCustomOptions(OptionGroup optionGroup, String groupName) {
        for (Trinity each : this.myCustomOptions.get((Object)groupName)) {
            this.doCreateOption(optionGroup, (String)each.third, new IntOption((String)each.third, (Class)each.first, (String)each.second), (String)each.second);
        }
    }

    private void createOption(OptionGroup optionGroup, String title, String fieldName) {
        if (this.myAllOptionsAllowed || this.myAllowedOptions.contains(fieldName)) {
            this.doCreateOption(optionGroup, title, new IntOption(title, fieldName), fieldName);
        }
    }

    private void doCreateOption(OptionGroup optionGroup, String title, IntOption option2, String fieldName) {
        String renamed = this.myRenamedFields.get(fieldName);
        if (renamed != null) {
            title = renamed;
        }
        JBLabel l = new JBLabel(title);
        optionGroup.add((JComponent)l, (JComponent)option2.myIntField);
        this.myOptions.add(option2);
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        for (IntOption option2 : this.myOptions) {
            option2.setValue(option2.getFieldValue(settings));
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        for (IntOption option2 : this.myOptions) {
            option2.myIntField.validateContent();
        }
        for (IntOption option2 : this.myOptions) {
            option2.setFieldValue(settings, option2.getValue());
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        for (IntOption option2 : this.myOptions) {
            if (option2.getFieldValue(settings) == option2.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    public void showAllStandardOptions() {
        this.myAllOptionsAllowed = true;
        for (IntOption option2 : this.myOptions) {
            option2.myIntField.setEnabled(true);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        if (this.myIsFirstUpdate) {
            Collections.addAll(this.myAllowedOptions, optionNames);
        }
        block0: for (IntOption option2 : this.myOptions) {
            option2.myIntField.setEnabled(false);
            for (String optionName : optionNames) {
                if (!option2.myTarget.getName().equals(optionName)) continue;
                option2.myIntField.setEnabled(true);
                continue block0;
            }
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName, Object ... options) {
        if (this.myIsFirstUpdate) {
            this.myCustomOptions.putValue((Object)groupName, (Object)Trinity.create(settingsClass, (Object)fieldName, (Object)title));
        }
        for (IntOption option2 : this.myOptions) {
            if (!option2.myTarget.getName().equals(fieldName)) continue;
            option2.myIntField.setEnabled(true);
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        if (this.myIsFirstUpdate) {
            this.myRenamedFields.put(fieldName, newTitle);
        }
        for (IntOption option2 : this.myOptions) {
            option2.myIntField.invalidate();
        }
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]);
    }

    private class IntOption {
        private final IntegerField myIntField;
        private final Field myTarget;
        private Class<? extends CustomCodeStyleSettings> myTargetClass;
        private int myCurrValue = Integer.MAX_VALUE;

        private IntOption(String title, String fieldName) {
            this(title, CommonCodeStyleSettings.class, fieldName, false);
        }

        private IntOption(String title, Class<? extends CustomCodeStyleSettings> targetClass, String fieldName) {
            this(title, targetClass, fieldName, false);
            this.myTargetClass = targetClass;
        }

        private IntOption(String title, Class<?> fieldClass, String fieldName, boolean dummy) {
            try {
                this.myTarget = fieldClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            this.myIntField = new IntegerField(null, 0, 10);
            this.myIntField.setColumns(6);
            this.myIntField.setName(title);
            this.myIntField.setMinimumSize(new Dimension(30, this.myIntField.getMinimumSize().height));
        }

        private int getFieldValue(CodeStyleSettings settings) {
            try {
                if (this.myTargetClass != null) {
                    return this.myTarget.getInt(settings.getCustomSettings(this.myTargetClass));
                }
                CommonCodeStyleSettings commonSettings = settings.getCommonSettings(CodeStyleBlankLinesPanel.this.getDefaultLanguage());
                return this.myTarget.getInt(commonSettings);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void setFieldValue(CodeStyleSettings settings, int value) {
            try {
                if (this.myTargetClass != null) {
                    this.myTarget.setInt(settings.getCustomSettings(this.myTargetClass), value);
                } else {
                    CommonCodeStyleSettings commonSettings = settings.getCommonSettings(CodeStyleBlankLinesPanel.this.getDefaultLanguage());
                    this.myTarget.setInt(commonSettings, value);
                }
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }

        private int getValue() {
            try {
                this.myCurrValue = Integer.parseInt(this.myIntField.getText());
                if (this.myCurrValue < 0) {
                    this.myCurrValue = 0;
                }
                if (this.myCurrValue > 10) {
                    this.myCurrValue = 10;
                }
            }
            catch (NumberFormatException e) {
                this.myCurrValue = 0;
            }
            return this.myCurrValue;
        }

        public void setValue(int fieldValue) {
            if (fieldValue != this.myCurrValue) {
                this.myCurrValue = fieldValue;
                this.myIntField.setText(String.valueOf(fieldValue));
            }
        }
    }
}

