/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.CommonBundle;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesUIConfiguration;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CodeStyleSchemesActions
extends AbstractSchemeActions<CodeStyleScheme> {
    private static final String SHARED_IMPORT_SOURCE = ApplicationBundle.message((String)"import.scheme.shared", (Object[])new Object[0]);

    CodeStyleSchemesActions(@NotNull AbstractSchemesPanel<CodeStyleScheme, ?> schemesPanel) {
        super(schemesPanel);
    }

    @Override
    protected void resetScheme(@NotNull CodeStyleScheme scheme2) {
        if (Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"settings.code.style.reset.to.defaults.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"settings.code.style.reset.to.defaults.title", (Object[])new Object[0]), (String)"Restore", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
            this.getModel().restoreDefaults(scheme2);
        }
    }

    @Override
    protected void duplicateScheme(@NotNull CodeStyleScheme scheme2, @NotNull String newName) {
        if (!this.getModel().isProjectScheme(scheme2)) {
            CodeStyleScheme newScheme = this.getModel().createNewScheme(newName, (CodeStyleScheme)this.getCurrentScheme());
            this.getModel().addScheme(newScheme, true);
        }
    }

    @Override
    protected void importScheme(@NotNull String importerName) {
        CodeStyleScheme currentScheme = (CodeStyleScheme)this.getCurrentScheme();
        if (currentScheme != null) {
            this.chooseAndImport(currentScheme, importerName);
        }
    }

    @Override
    protected void copyToIDE(@NotNull CodeStyleScheme scheme2) {
        this.getSchemesPanel().editNewSchemeName(this.getProjectName(), false, newName -> {
            CodeStyleScheme newScheme = this.getModel().exportProjectScheme((String)newName);
            this.getModel().selectScheme(newScheme, null);
        });
    }

    @NotNull
    private String getProjectName() {
        Project project = ProjectUtil.guessCurrentProject(this.getSchemesPanel());
        return project.getName();
    }

    private void chooseAndImport(@NotNull CodeStyleScheme currentScheme, @NotNull String importerName) {
        if (importerName.equals(SHARED_IMPORT_SOURCE)) {
            new SchemesToImportPopup<CodeStyleScheme>(this.getSchemesPanel()){

                @Override
                protected void onSchemeSelected(CodeStyleScheme scheme2) {
                    if (scheme2 != null) {
                        CodeStyleSchemesActions.this.getModel().addScheme(scheme2, true);
                    }
                }
            }.show(this.getModel().getSchemes());
        } else {
            SchemeImporter<CodeStyleScheme> importer = SchemeImporterEP.getImporter(importerName, CodeStyleScheme.class);
            if (importer == null) {
                return;
            }
            try {
                CodeStyleScheme scheme2 = this.importExternalCodeStyle(importer, currentScheme);
                if (scheme2 != null) {
                    String additionalImportInfo = StringUtil.notNullize((String)importer.getAdditionalImportInfo((Scheme)scheme2));
                    this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"message.code.style.scheme.import.success", (Object[])new Object[]{importerName, scheme2.getName(), additionalImportInfo}), MessageType.INFO);
                }
            }
            catch (SchemeImportException e) {
                if (e.isWarning()) {
                    this.getSchemesPanel().showStatus(e.getMessage(), MessageType.WARNING);
                    return;
                }
                String message = ApplicationBundle.message((String)"message.code.style.scheme.import.failure", (Object[])new Object[]{importerName, e.getMessage()});
                this.getSchemesPanel().showStatus(message, MessageType.ERROR);
            }
        }
    }

    @Nullable
    private CodeStyleScheme importExternalCodeStyle(@NotNull SchemeImporter<CodeStyleScheme> importer, @NotNull CodeStyleScheme currentScheme) throws SchemeImportException {
        VirtualFile selectedFile = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.getSchemesPanel(), CodeStyleSchemesUIConfiguration.Util.getRecentImportFile(), null);
        if (selectedFile != null) {
            CodeStyleSchemesUIConfiguration.Util.setRecentImportFile(selectedFile);
            SchemeCreator schemeCreator = new SchemeCreator();
            CodeStyleScheme schemeImported = (CodeStyleScheme)importer.importScheme(this.getModel().getProject(), selectedFile, (Scheme)currentScheme, (SchemeFactory)schemeCreator);
            if (schemeImported != null) {
                if (schemeCreator.isSchemeWasCreated()) {
                    this.getModel().fireSchemeListChanged();
                } else {
                    this.getModel().updateScheme(schemeImported);
                }
                return schemeImported;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected Class<CodeStyleScheme> getSchemeType() {
        return CodeStyleScheme.class;
    }

    @Override
    public void copyToProject(@NotNull CodeStyleScheme scheme2) {
        int copyToProjectConfirmation = Messages.showYesNoDialog((String)ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project.message", (Object[])new Object[]{scheme2.getName()}), (String)ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (copyToProjectConfirmation == 0) {
            this.getModel().copyToProject(scheme2);
        }
    }

    @NotNull
    protected CodeStyleSchemesModel getModel() {
        return (CodeStyleSchemesModel)super.getModel();
    }

    private class SchemeCreator
    implements SchemeFactory<CodeStyleScheme> {
        private boolean mySchemeWasCreated;

        private SchemeCreator() {
        }

        @NotNull
        public CodeStyleScheme createNewScheme(@Nullable String targetName) {
            this.mySchemeWasCreated = true;
            if (targetName == null) {
                targetName = ApplicationBundle.message((String)"code.style.scheme.import.unnamed", (Object[])new Object[0]);
            }
            CodeStyleScheme newScheme = CodeStyleSchemesActions.this.getModel().createNewScheme(targetName, (CodeStyleScheme)CodeStyleSchemesActions.this.getCurrentScheme());
            CodeStyleSchemesActions.this.getModel().addScheme(newScheme, true);
            return newScheme;
        }

        boolean isSchemeWasCreated() {
            return this.mySchemeWasCreated;
        }
    }
}

