/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModelListener;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesModel
implements SchemesModel<CodeStyleScheme> {
    private final List<CodeStyleScheme> mySchemes = new ArrayList<CodeStyleScheme>();
    private CodeStyleScheme mySelectedScheme;
    private final CodeStyleScheme myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
    private final EventDispatcher<CodeStyleSchemesModelListener> myDispatcher = EventDispatcher.create(CodeStyleSchemesModelListener.class);
    private final Project myProject;
    private boolean myUiEventsEnabled = true;

    public CodeStyleSchemesModel(Project project) {
        this.myProject = project;
        this.myProjectScheme = new ProjectScheme();
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
        this.reset();
    }

    public void selectScheme(CodeStyleScheme selected, @Nullable Object source) {
        if (this.mySelectedScheme != selected) {
            this.mySelectedScheme = selected;
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    @Override
    public void removeScheme(@NotNull CodeStyleScheme scheme2) {
        this.mySchemes.remove(scheme2);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.mySelectedScheme == scheme2) {
            this.selectScheme(this.myDefault, this);
        }
    }

    @NotNull
    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme2) {
        if (!this.mySettingsToClone.containsKey(scheme2)) {
            this.mySettingsToClone.put(scheme2, ModelSettings.createFrom(scheme2.getCodeStyleSettings()));
        }
        return this.mySettingsToClone.get(scheme2);
    }

    public CodeStyleScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public void addListener(CodeStyleSchemesModelListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.mySchemes.clear();
        ContainerUtil.addAll(this.mySchemes, CodeStyleSchemesImpl.getSchemeManager().getAllSchemes());
        this.mySchemes.add(this.myProjectScheme);
        this.updateClonedSettings();
        this.mySelectedScheme = this.getProjectSettings().USE_PER_PROJECT_SETTINGS ? this.myProjectScheme : CodeStyleSchemes.getInstance().findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
    }

    private void updateClonedSettings() {
        Iterator<CodeStyleScheme> schemeIterator = this.mySettingsToClone.keySet().iterator();
        while (schemeIterator.hasNext()) {
            CodeStyleScheme scheme2 = schemeIterator.next();
            if (this.mySchemes.contains(scheme2)) continue;
            schemeIterator.remove();
        }
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            CodeStyleSettings current = scheme2.getCodeStyleSettings();
            CodeStyleSettings clonedSettings = this.getCloneSettings(scheme2);
            clonedSettings.copyFrom(current);
        }
    }

    public boolean isUsePerProjectSettings() {
        return this.mySelectedScheme instanceof ProjectScheme;
    }

    private CodeStyleSettingsManager getProjectSettings() {
        return CodeStyleSettingsManager.getInstance((Project)this.myProject);
    }

    public boolean isSchemeListModified() {
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        if (this.getProjectSettings().USE_PER_PROJECT_SETTINGS != this.isProjectScheme(this.mySelectedScheme)) {
            return true;
        }
        if (!this.isProjectScheme(this.mySelectedScheme) && this.getSelectedScheme() != schemes.findPreferredScheme(this.getProjectSettings().PREFERRED_PROJECT_CODE_STYLE)) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getIdeSchemes());
        return !configuredSchemesSet.equals(new THashSet(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()));
    }

    public void apply() {
        this.commitClonedSettings();
        this.commitProjectSettings();
        CodeStyleSchemesImpl.getSchemeManager().setSchemes(this.getIdeSchemes(), this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme, null);
    }

    private void commitProjectSettings() {
        CodeStyleSettingsManager projectSettingsManager = this.getProjectSettings();
        projectSettingsManager.USE_PER_PROJECT_SETTINGS = this.isProjectScheme(this.mySelectedScheme);
        projectSettingsManager.PREFERRED_PROJECT_CODE_STYLE = this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme.getName();
        CodeStyleSettings projectSettings = this.myProjectScheme.getCodeStyleSettings();
        projectSettings.getModificationTracker().incModificationCount();
        projectSettingsManager.setMainProjectCodeStyle(projectSettings);
    }

    private void commitClonedSettings() {
        for (CodeStyleScheme scheme2 : this.mySettingsToClone.keySet()) {
            if (scheme2 instanceof ProjectScheme) continue;
            CodeStyleSettings settings = scheme2.getCodeStyleSettings();
            settings.copyFrom(this.mySettingsToClone.get(scheme2));
            settings.getModificationTracker().incModificationCount();
        }
    }

    @NotNull
    private List<CodeStyleScheme> getIdeSchemes() {
        return ContainerUtil.filter(this.mySchemes, scheme2 -> !(scheme2 instanceof ProjectScheme));
    }

    @Deprecated
    public static boolean cannotBeModified(CodeStyleScheme currentScheme) {
        return false;
    }

    public void fireBeforeCurrentSettingsChanged() {
        if (this.myUiEventsEnabled) {
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).beforeCurrentSettingsChanged();
        }
    }

    void updateScheme(CodeStyleScheme scheme2) {
        CodeStyleSettings clonedSettings = this.getCloneSettings(scheme2);
        clonedSettings.copyFrom(scheme2.getCodeStyleSettings());
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeChanged(scheme2);
    }

    public void fireSchemeListChanged() {
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
    }

    public void fireAfterCurrentSettingsChanged() {
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).afterCurrentSettingsChanged();
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        this.myProjectScheme.getCodeStyleSettings().copyFrom(selectedScheme.getCodeStyleSettings());
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
        this.commitProjectSettings();
        this.selectScheme(this.myProjectScheme, this);
    }

    public CodeStyleScheme exportProjectScheme(@NotNull String name) {
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(this.getCloneSettings(this.myProjectScheme).clone());
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        boolean isProjectScheme = this.isProjectScheme(parentScheme);
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.containsScheme((String)name, isProjectScheme)), false, parentScheme);
    }

    @Nullable
    private CodeStyleScheme findSchemeByName(String name, boolean isProjectScheme) {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            if (isProjectScheme != this.isProjectScheme(scheme2) || !name.equals(scheme2.getName())) continue;
            return scheme2;
        }
        return null;
    }

    public CodeStyleScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull CodeStyleScheme scheme2) {
        return !this.isProjectScheme(scheme2);
    }

    @Override
    public boolean canResetScheme(@NotNull CodeStyleScheme scheme2) {
        return scheme2.isDefault();
    }

    @Override
    public boolean canDeleteScheme(@NotNull CodeStyleScheme scheme2) {
        return !this.isProjectScheme(scheme2) && !scheme2.isDefault();
    }

    @Override
    public boolean isProjectScheme(@NotNull CodeStyleScheme scheme2) {
        return scheme2 instanceof ProjectScheme;
    }

    @Override
    public boolean canRenameScheme(@NotNull CodeStyleScheme scheme2) {
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectScheme) {
        return this.findSchemeByName(name, isProjectScheme) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull CodeStyleScheme scheme2) {
        CodeStyleSettings clonedSettings;
        CodeStyleSettings defaults = CodeStyleSettings.getDefaults();
        return !defaults.equals((Object)(clonedSettings = this.getCloneSettings(scheme2)));
    }

    public List<CodeStyleScheme> getAllSortedSchemes() {
        ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.getSchemes());
        Collections.sort(schemes, (s1, s2) -> {
            if (this.isProjectScheme((CodeStyleScheme)s1)) {
                return -1;
            }
            if (this.isProjectScheme((CodeStyleScheme)s2)) {
                return 1;
            }
            if (s1.isDefault()) {
                return -1;
            }
            if (s2.isDefault()) {
                return 1;
            }
            return s1.getName().compareToIgnoreCase(s2.getName());
        });
        return schemes;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void restoreDefaults(@NotNull CodeStyleScheme scheme2) {
        if (this.canResetScheme(scheme2)) {
            CodeStyleSettings currSettings = this.getCloneSettings(scheme2);
            currSettings.copyFrom(CodeStyleSettings.getDefaults());
            this.myUiEventsEnabled = false;
            try {
                ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).settingsChanged(currSettings);
            }
            finally {
                this.myUiEventsEnabled = true;
            }
        }
    }

    public boolean containsModifiedCodeStyleSettings() {
        for (CodeStyleScheme scheme2 : this.mySchemes) {
            CodeStyleSettings originalSettings = scheme2.getCodeStyleSettings();
            CodeStyleSettings currentSettings = this.mySettingsToClone.get(scheme2);
            if (currentSettings == null || originalSettings.equals((Object)currentSettings)) continue;
            return true;
        }
        return false;
    }

    public void setUiEventsEnabled(boolean enabled) {
        this.myUiEventsEnabled = enabled;
    }

    public boolean isUiEventsEnabled() {
        return this.myUiEventsEnabled;
    }

    public static class ModelSettings
    extends CodeStyleSettings {
        private volatile boolean myLocked;

        public static ModelSettings createFrom(@NotNull CodeStyleSettings settings) {
            ModelSettings modelSettings = new ModelSettings();
            modelSettings.copyFrom(settings);
            return modelSettings;
        }

        public void doWithLockedSettings(@NotNull Runnable runnable2) {
            this.myLocked = true;
            runnable2.run();
            this.myLocked = false;
        }

        public boolean isLocked() {
            return this.myLocked;
        }
    }

    private class ProjectScheme
    extends CodeStyleSchemeImpl {
        ProjectScheme() {
            super("Project", false, CodeStyleSchemes.getInstance().getDefaultScheme());
            CodeStyleSettings perProjectSettings = CodeStyleSchemesModel.this.getProjectSettings().getMainProjectCodeStyle();
            if (perProjectSettings != null) {
                this.setCodeStyleSettings(perProjectSettings);
            }
        }
    }
}

