/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomizableLanguageCodeStylePanel
extends CodeStyleAbstractPanel
implements CodeStyleSettingsCustomizable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel");

    protected CustomizableLanguageCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
    }

    protected void init() {
        this.customizeSettings();
    }

    protected void customizeSettings() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.getDefaultLanguage());
        if (provider != null) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
        }
    }

    public abstract LanguageCodeStyleSettingsProvider.SettingsType getSettingsType();

    protected void resetDefaultNames() {
    }

    @Override
    protected String getPreviewText() {
        if (this.getDefaultLanguage() == null) {
            return "";
        }
        String sample = LanguageCodeStyleSettingsProvider.getCodeSample((Language)this.getDefaultLanguage(), (LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
        if (sample == null) {
            return "";
        }
        return sample;
    }

    @Override
    protected int getRightMargin() {
        if (this.getDefaultLanguage() == null) {
            return -1;
        }
        return LanguageCodeStyleSettingsProvider.getRightMargin((Language)this.getDefaultLanguage(), (LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType());
    }

    @Override
    protected String getFileExt() {
        String fileExt = LanguageCodeStyleSettingsProvider.getFileExt((Language)this.getDefaultLanguage());
        if (fileExt != null) {
            return fileExt;
        }
        return super.getFileExt();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType assocType;
        if (this.getDefaultLanguage() != null && (assocType = this.getDefaultLanguage().getAssociatedFileType()) != null) {
            return assocType;
        }
        return StdFileTypes.JAVA;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        FileType fileType = this.getFileType();
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), fileType, null, scheme2);
    }

    @Override
    protected PsiFile doReformat(Project project, PsiFile psiFile) {
        String text = psiFile.getText();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document doc = manager.getDocument(psiFile);
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (doc != null) {
                doc.replaceString(0, doc.getTextLength(), (CharSequence)text);
                manager.commitDocument(doc);
            }
            try {
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), "", (Object)"");
        if (doc != null) {
            manager.commitDocument(doc);
        }
        return psiFile;
    }

    protected static JPanel createPreviewPanel() {
        return new JPanel(new BorderLayout());
    }

    public void moveStandardOption(String fieldName, String newGroup) {
        throw new UnsupportedOperationException();
    }

    protected <T extends OrderedOption> List<T> sortOptions(Collection<T> options) {
        THashSet names = new THashSet((Collection)ContainerUtil.map(options, option2 -> option2.getOptionName()));
        ArrayList<OrderedOption> order = new ArrayList<OrderedOption>(options.size());
        MultiMap afters = new MultiMap();
        MultiMap befores = new MultiMap();
        for (OrderedOption each : options) {
            String anchorOptionName = each.getAnchorOptionName();
            if (anchorOptionName != null && names.contains(anchorOptionName)) {
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.AFTER) {
                    afters.putValue((Object)anchorOptionName, (Object)each);
                    continue;
                }
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.BEFORE) {
                    befores.putValue((Object)anchorOptionName, (Object)each);
                    continue;
                }
            }
            order.add(each);
        }
        ArrayList<OrderedOption> result2 = new ArrayList<OrderedOption>(options.size());
        for (OrderedOption each : order) {
            result2.addAll(befores.get((Object)each.getOptionName()));
            result2.add(each);
            result2.addAll(afters.get((Object)each.getOptionName()));
        }
        assert (result2.size() == options.size());
        return result2;
    }

    protected static abstract class OrderedOption {
        @NotNull
        private final String optionName;
        @Nullable
        private final CodeStyleSettingsCustomizable.OptionAnchor anchor;
        @Nullable
        private final String anchorOptionName;

        protected OrderedOption(@NotNull String optionName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorOptionName) {
            this.optionName = optionName;
            this.anchor = anchor2;
            this.anchorOptionName = anchorOptionName;
        }

        @NotNull
        public String getOptionName() {
            return this.optionName;
        }

        @Nullable
        public CodeStyleSettingsCustomizable.OptionAnchor getAnchor() {
            return this.anchor;
        }

        @Nullable
        public String getAnchorOptionName() {
            return this.anchorOptionName;
        }
    }
}

