/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.fields.valueEditors.CommaSeparatedIntegersValueEditor;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class MarginOptionsUtil {
    MarginOptionsUtil() {
    }

    public static String getDefaultRightMarginText(@NotNull CodeStyleSettings settings) {
        return MarginOptionsUtil.getDefaultValueText(Integer.toString(settings.getDefaultRightMargin()));
    }

    static String getDefaultVisualGuidesText(@NotNull CodeStyleSettings settings) {
        List softMargins = settings.getDefaultSoftMargins();
        return MarginOptionsUtil.getDefaultValueText(softMargins.size() > 0 ? CommaSeparatedIntegersValueEditor.intListToString((List)settings.getDefaultSoftMargins()) : ApplicationBundle.message((String)"settings.soft.margins.empty.list", (Object[])new Object[0]));
    }

    static String getDefaultWrapOnTypingText(@NotNull CodeStyleSettings settings) {
        return MarginOptionsUtil.getDefaultValueText(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ? "Yes" : "No");
    }

    static void customizeWrapOnTypingCombo(@NotNull JComboBox<String> wrapOnTypingCombo, @NotNull CodeStyleSettings settings) {
        wrapOnTypingCombo.setRenderer((ListCellRenderer<String>)((Object)new WrapOnTypingListCellRenderer(settings)));
    }

    static String getDefaultValueText(@NotNull String value) {
        return ApplicationBundle.message((String)"settings.default.value.prefix", (Object[])new Object[]{value});
    }

    static class WrapOnTypingListCellRenderer
    extends ListCellRendererWrapper<String> {
        private final CodeStyleSettings mySettings;

        WrapOnTypingListCellRenderer(@NotNull CodeStyleSettings settings) {
            this.mySettings = settings;
        }

        public void customize(JList list2, String value, int index, boolean selected, boolean hasFocus) {
            for (int i = 0; i < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES.length; ++i) {
                if (CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES[i] != CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue || !CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS[i].equals(value)) continue;
                this.setText(MarginOptionsUtil.getDefaultWrapOnTypingText(this.mySettings));
            }
        }
    }
}

