/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCodeStyleSettingsPanel
extends JPanel
implements TabbedLanguageCodeStylePanel.TabChangeListener {
    private static final Logger LOG = Logger.getInstance(NewCodeStyleSettingsPanel.class);
    private final Configurable myTab;
    private final CodeStyleSchemesModel myModel;

    public NewCodeStyleSettingsPanel(@NotNull Configurable tab, @NotNull CodeStyleSchemesModel model) {
        super(new BorderLayout());
        this.myTab = tab;
        this.myModel = model;
        JComponent component = this.myTab.createComponent();
        if (component != null) {
            this.add((Component)component, "Center");
        } else {
            LOG.warn("No component for " + tab.getDisplayName());
        }
    }

    public boolean isModified() {
        return this.myTab.isModified();
    }

    public void updatePreview() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).getPanel().onSomethingChanged();
        }
    }

    public void apply() throws ConfigurationException {
        if (this.myTab.isModified()) {
            this.myTab.apply();
        }
    }

    @Nullable
    public String getHelpTopic() {
        return this.myTab.getHelpTopic();
    }

    public void dispose() {
        this.myTab.disposeUIResources();
    }

    public void reset(CodeStyleSettings settings) {
        try {
            this.myModel.setUiEventsEnabled(false);
            if (this.myTab instanceof CodeStyleConfigurable) {
                ((CodeStyleConfigurable)this.myTab).reset(settings);
            } else {
                this.myTab.reset();
            }
            this.updatePreview();
        }
        finally {
            this.myModel.setUiEventsEnabled(true);
        }
    }

    public void reset() {
        this.myTab.reset();
        this.updatePreview();
    }

    public String getDisplayName() {
        return this.myTab.getDisplayName();
    }

    public void setModel(@NotNull CodeStyleSchemesModel model) {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).setModel(model);
        }
    }

    public void onSomethingChanged() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            ((CodeStyleAbstractConfigurable)this.myTab).onSomethingChanged();
        }
    }

    @NotNull
    public Set<String> processListOptions() {
        if (this.myTab instanceof OptionsContainingConfigurable) {
            return ((OptionsContainingConfigurable)this.myTab).processListOptions();
        }
        return Collections.emptySet();
    }

    @Nullable
    public CodeStyleAbstractPanel getSelectedPanel() {
        if (this.myTab instanceof CodeStyleAbstractConfigurable) {
            return ((CodeStyleAbstractConfigurable)this.myTab).getPanel();
        }
        return null;
    }

    @Override
    public void tabChanged(@NotNull TabbedLanguageCodeStylePanel source, @NotNull String tabTitle) {
        CodeStyleAbstractPanel panel2 = this.getSelectedPanel();
        if (panel2 instanceof TabbedLanguageCodeStylePanel && panel2 != source) {
            ((TabbedLanguageCodeStylePanel)panel2).changeTab(tabTitle);
        }
    }
}

