/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionTableWithPreviewPanel
extends CustomizableLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(OptionTableWithPreviewPanel.class);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);
    protected TreeTable myTreeTable;
    private final JPanel myPanel = new JPanel();
    private final List<Option> myOptions = new ArrayList<Option>();
    private final List<Option> myCustomOptions = new ArrayList<Option>();
    private final Set<String> myAllowedOptions = new THashSet();
    private final Map<String, String> myRenamedFields = new THashMap();
    private boolean myShowAllStandardOptions;
    protected boolean isFirstUpdate = true;
    public final ColumnInfo TITLE = new ColumnInfo("TITLE"){

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o;
                return node.getText();
            }
            return o.toString();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }
    };
    public final ColumnInfo VALUE = new ColumnInfo("VALUE"){
        private final TableCellEditor myEditor;
        private final TableCellRenderer myRenderer;
        {
            this.myEditor = new MyValueEditor();
            this.myRenderer = new MyValueRenderer();
        }

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o;
                return node.getValue();
            }
            return null;
        }

        public TableCellRenderer getRenderer(Object o) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(Object item) {
            return this.myEditor;
        }

        public boolean isCellEditable(Object o) {
            return o instanceof MyTreeNode && ((MyTreeNode)o).isEnabled();
        }

        public void setValue(Object o, Object o1) {
            MyTreeNode node = (MyTreeNode)o;
            node.setValue(o1);
        }
    };
    public final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.TITLE, this.VALUE};
    private final TreeCellRenderer myTitleRenderer = new TreeCellRenderer(){
        private final JLabel myLabel = new JLabel();

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (value instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)value;
                this.myLabel.setText(OptionTableWithPreviewPanel.this.getRenamedTitle(node.getKey().getOptionName(), node.getText()));
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(node.getKey().groupName == null ? 1 : 0));
                this.myLabel.setEnabled(node.isEnabled());
            } else {
                this.myLabel.setText(OptionTableWithPreviewPanel.this.getRenamedTitle(value.toString(), value.toString()));
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
                this.myLabel.setEnabled(true);
            }
            Color foreground = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.myLabel.setForeground(foreground);
            return this.myLabel;
        }
    };

    public OptionTableWithPreviewPanel(CodeStyleSettings settings) {
        super(settings);
    }

    @Override
    protected void init() {
        super.init();
        this.myPanel.setLayout(new GridBagLayout());
        this.initTables();
        this.myTreeTable = this.createOptionsTree(this.getSettings());
        this.myTreeTable.setBackground(UIUtil.getPanelBackground());
        this.myTreeTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel previewPanel = OptionTableWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.isFirstUpdate = false;
        this.customizeSettings();
    }

    @Override
    protected void resetDefaultNames() {
        this.myRenamedFields.clear();
    }

    public void showAllStandardOptions() {
        this.myShowAllStandardOptions = true;
        for (Option each : this.myOptions) {
            each.setEnabled(true);
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        Collections.addAll(this.myAllowedOptions, optionNames);
        for (Option each : this.myOptions) {
            each.setEnabled(false);
            for (String optionName : optionNames) {
                if (!each.getOptionName().equals(optionName)) continue;
                each.setEnabled(true);
            }
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName, Object ... options) {
        if (this.isFirstUpdate) {
            FieldOption option2 = options.length == 2 ? new SelectionOption(settingsClass, fieldName, title, groupName, anchor2, anchorFieldName, (String[])options[0], (int[])options[1]) : new BooleanOption(settingsClass, fieldName, title, groupName, anchor2, anchorFieldName);
            this.myCustomOptions.add(option2);
            option2.setEnabled(true);
        } else {
            for (Option each : this.myCustomOptions) {
                if (!(each instanceof FieldOption) || ((FieldOption)each).clazz != settingsClass || !each.getOptionName().equals(fieldName)) continue;
                each.setEnabled(true);
            }
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        this.myRenamedFields.put(fieldName, newTitle);
    }

    public void showOption(@NotNull String optionName) {
        this.myAllowedOptions.add(optionName);
    }

    protected TreeTable createOptionsTree(CodeStyleSettings settings) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        THashMap groupsMap = new THashMap();
        List sorted = this.sortOptions(ContainerUtil.concat(this.myOptions, this.myCustomOptions));
        for (Option each : sorted) {
            String groupName;
            if (!this.myCustomOptions.contains(each) && !this.myAllowedOptions.contains(each.getOptionName()) && !this.myShowAllStandardOptions) continue;
            String group = each.groupName;
            MyTreeNode newNode = new MyTreeNode(each, each.title, settings);
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupsMap.get(group);
            if (groupNode != null) {
                groupNode.add(newNode);
                continue;
            }
            if (group == null) {
                groupName = each.title;
                groupNode = newNode;
            } else {
                groupName = group;
                groupNode = new DefaultMutableTreeNode(groupName);
                groupNode.add(newNode);
            }
            groupsMap.put(groupName, groupNode);
            rootNode.add(groupNode);
        }
        ListTreeTableModel model = new ListTreeTableModel((TreeNode)rootNode, this.COLUMNS);
        TreeTable treeTable = new TreeTable((TreeTableModel)model){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                UIUtil.setLineStyleAngled((ClientPropertyHolder)tableRenderer);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row2, int column) {
                TreePath treePath = this.getTree().getPathForRow(row2);
                if (treePath == null) {
                    return super.getCellRenderer(row2, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellRenderer renderer2 = OptionTableWithPreviewPanel.this.COLUMNS[column].getRenderer(node);
                return renderer2 == null ? super.getCellRenderer(row2, column) : renderer2;
            }

            public TableCellEditor getCellEditor(int row2, int column) {
                TreePath treePath = this.getTree().getPathForRow(row2);
                if (treePath == null) {
                    return super.getCellEditor(row2, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellEditor editor = OptionTableWithPreviewPanel.this.COLUMNS[column].getEditor(node);
                return editor == null ? super.getCellEditor(row2, column) : editor;
            }
        };
        new TreeTableSpeedSearch(treeTable).setComparator(new SpeedSearchComparator(false));
        treeTable.setRootVisible(false);
        TreeTableTree tree = treeTable.getTree();
        tree.setCellRenderer(this.myTitleRenderer);
        tree.setShowsRootHandles(true);
        treeTable.setSelectionMode(0);
        treeTable.setTableHeader(null);
        TreeUtil.expandAll((JTree)tree);
        treeTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable.setPreferredScrollableViewportSize(new Dimension(maxWidth + valueSize.width + 10, 20));
        return treeTable;
    }

    private String getRenamedTitle(String fieldOrGroupName, String defaultName) {
        String result2 = this.myRenamedFields.get(fieldOrGroupName);
        return result2 == null ? defaultName : result2;
    }

    protected abstract void initTables();

    private static void resetNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).reset(settings);
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child2 = node.getChildAt(j);
            OptionTableWithPreviewPanel.resetNode(child2, settings);
        }
    }

    private static void applyNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).apply(settings);
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child2 = node.getChildAt(j);
            OptionTableWithPreviewPanel.applyNode(child2, settings);
        }
    }

    private static boolean isModified(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode && ((MyTreeNode)node).isModified(settings)) {
            return true;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child2 = node.getChildAt(j);
            if (!OptionTableWithPreviewPanel.isModified(child2, settings)) continue;
            return true;
        }
        return false;
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title) {
        this.addOption(fieldName, title, null);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @NotNull String[] options, @NotNull int[] values) {
        this.addOption(fieldName, title, null, options, values);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, int minValue, int maxValue, int defaultValue, @Nullable Function<Integer, String> defaultValueRenderer) {
        this.myOptions.add(new IntOption(null, fieldName, title, groupName, null, null, minValue, maxValue, defaultValue, defaultValueRenderer));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName) {
        this.myOptions.add(new BooleanOption(null, fieldName, title, groupName, null, null));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, @NotNull String[] options, @NotNull int[] values) {
        this.myOptions.add(new SelectionOption(null, fieldName, title, groupName, null, null, options, values));
    }

    protected void addCustomOption(@NotNull Option option2) {
        this.myOptions.add(option2);
    }

    @Nullable
    protected JComponent getCustomValueRenderer(@NotNull String optionName, @NotNull Object value) {
        return null;
    }

    @Nullable
    protected JComponent getCustomNodeEditor(@NotNull MyTreeNode node) {
        return null;
    }

    @Nullable
    protected Object getCustomNodeEditorValue(@NotNull JComponent customEditor) {
        return null;
    }

    @Override
    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        TableCellEditor editor = this.myTreeTable.getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            throw new ConfigurationException("Editing cannot be stopped");
        }
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTableWithPreviewPanel.applyNode(root, settings);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        TableCellEditor editor = this.myTreeTable.getCellEditor();
        if (editor != null) {
            return true;
        }
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return OptionTableWithPreviewPanel.isModified(root, settings);
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTableWithPreviewPanel.resetNode(root, settings);
        ((DefaultTreeModel)treeModel).nodeChanged(root);
    }

    @Override
    @NotNull
    public Set<String> processListOptions() {
        HashSet<String> options = new HashSet<String>();
        OptionTableWithPreviewPanel.collectOptions(options, this.myOptions);
        OptionTableWithPreviewPanel.collectOptions(options, this.myCustomOptions);
        return options;
    }

    private static void collectOptions(Set<? super String> optionNames, List<? extends Option> optionList) {
        for (Option option2 : optionList) {
            if (option2.groupName != null) {
                optionNames.add(option2.groupName);
            }
            optionNames.add(option2.title);
        }
    }

    private class MyValueEditor
    extends AbstractTableCellEditor {
        public static final String STOP_CELL_EDIT_ACTION_KEY = "stopEdit";
        private final JCheckBox myBooleanEditor = new JBCheckBox();
        private final JBComboBoxTableCellEditorComponent myOptionsEditor = new JBComboBoxTableCellEditorComponent();
        private final IntegerField myIntOptionsEditor = new IntegerField();
        private JComponent myCurrentEditor = null;
        private MyTreeNode myCurrentNode = null;
        private final AbstractAction STOP_CELL_EDIT_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyValueEditor.this.stopCellEditing();
            }
        };

        MyValueEditor() {
            ActionListener itemChoosen = new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (MyValueEditor.this.myCurrentNode != null) {
                        MyValueEditor.this.myCurrentNode.setValue(MyValueEditor.this.getCellEditorValue());
                        OptionTableWithPreviewPanel.this.somethingChanged();
                    }
                }
            };
            this.myBooleanEditor.addActionListener(itemChoosen);
            this.myOptionsEditor.addActionListener(itemChoosen);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myBooleanEditor);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myOptionsEditor);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myIntOptionsEditor);
        }

        public Object getCellEditorValue() {
            if (this.myCurrentEditor == this.myOptionsEditor) {
                return this.myOptionsEditor.getEditorValue();
            }
            if (this.myCurrentEditor == this.myBooleanEditor) {
                return this.myBooleanEditor.isSelected();
            }
            if (this.myCurrentEditor == this.myIntOptionsEditor) {
                return this.myIntOptionsEditor.getValue();
            }
            Object value = OptionTableWithPreviewPanel.this.getCustomNodeEditorValue(this.myCurrentEditor);
            if (value != null) {
                return value;
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row2, int column) {
            DefaultMutableTreeNode defaultNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row2).getLastPathComponent();
            this.myCurrentEditor = null;
            this.myCurrentNode = null;
            if (defaultNode instanceof MyTreeNode) {
                MyTreeNode node;
                this.myCurrentNode = node = (MyTreeNode)defaultNode;
                if (node.getKey() instanceof BooleanOption) {
                    this.myCurrentEditor = this.myBooleanEditor;
                    this.myBooleanEditor.setSelected(node.getValue() == Boolean.TRUE);
                    this.myBooleanEditor.setEnabled(node.isEnabled());
                } else if (node.getKey() instanceof IntOption) {
                    IntOption intOption = (IntOption)node.getKey();
                    this.myCurrentEditor = this.myIntOptionsEditor;
                    this.myIntOptionsEditor.setCanBeEmpty(true);
                    this.myIntOptionsEditor.setMinValue(intOption.getMinValue());
                    this.myIntOptionsEditor.setMaxValue(intOption.getMaxValue());
                    this.myIntOptionsEditor.setDefaultValue(Integer.valueOf(intOption.getDefaultValue()));
                    this.myIntOptionsEditor.setValue((Integer)node.getValue());
                } else {
                    this.myCurrentEditor = OptionTableWithPreviewPanel.this.getCustomNodeEditor(node);
                }
                if (this.myCurrentEditor == null) {
                    this.myCurrentEditor = this.myOptionsEditor;
                    this.myOptionsEditor.setCell(table, row2, column);
                    this.myOptionsEditor.setText(String.valueOf(node.getValue()));
                    this.myOptionsEditor.setOptions((Object[])((SelectionOption)node.getKey()).options);
                    this.myOptionsEditor.setDefaultValue(node.getValue());
                }
            }
            if (this.myCurrentEditor != null) {
                this.myCurrentEditor.setBackground(table.getBackground());
                if (this.myCurrentEditor instanceof JTextField) {
                    this.myCurrentEditor.getInputMap().put(ENTER_KEY_STROKE, STOP_CELL_EDIT_ACTION_KEY);
                    this.myCurrentEditor.getActionMap().put(STOP_CELL_EDIT_ACTION_KEY, this.STOP_CELL_EDIT_ACTION);
                }
            }
            return this.myCurrentEditor;
        }
    }

    private class MyValueRenderer
    implements TableCellRenderer {
        private JTable myTable;
        private int myRow;
        private int myColumn;
        private final OptionsLabel myComboBox = new OptionsLabel();
        private final JCheckBox myCheckBox = new JBCheckBox();
        private final JPanel myEmptyLabel = new JPanel();
        private final JLabel myIntLabel = new JLabel();

        MyValueRenderer() {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myComboBox);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myCheckBox);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myIntLabel);
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            JComponent customRenderer;
            this.myTable = table;
            this.myRow = row2;
            this.myColumn = column;
            boolean isEnabled = true;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row2).getLastPathComponent();
            Option key = null;
            if (node instanceof MyTreeNode) {
                isEnabled = ((MyTreeNode)node).isEnabled();
                key = ((MyTreeNode)node).getKey();
            }
            if (!table.isEnabled()) {
                isEnabled = false;
            }
            Color background = table.getBackground();
            if (key != null && value != null && (customRenderer = OptionTableWithPreviewPanel.this.getCustomValueRenderer(key.getOptionName(), value)) != null) {
                return customRenderer;
            }
            if (value instanceof Boolean) {
                this.myCheckBox.setSelected((Boolean)value);
                this.myCheckBox.setBackground(background);
                this.myCheckBox.setEnabled(isEnabled);
                return this.myCheckBox;
            }
            if (value instanceof String) {
                this.myComboBox.setText((String)value);
                this.myComboBox.setBackground(background);
                this.myComboBox.setEnabled(isEnabled);
                return this.myComboBox;
            }
            if (value instanceof Integer) {
                if (key instanceof IntOption && ((IntOption)key).isDefaultValue(value)) {
                    this.myIntLabel.setText(((IntOption)key).getDefaultValueText());
                } else {
                    this.myIntLabel.setText(value.toString());
                }
                return this.myIntLabel;
            }
            this.myEmptyLabel.setBackground(background);
            return this.myEmptyLabel;
        }

        protected class OptionsLabel
        extends JLabel {
            protected OptionsLabel() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleOptionsLabel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleOptionsLabel
            extends JLabel.AccessibleJLabel
            implements AccessibleAction {
                protected AccessibleOptionsLabel() {
                    super(OptionsLabel.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PUSH_BUTTON;
                }

                @Override
                public AccessibleAction getAccessibleAction() {
                    return this;
                }

                @Override
                public int getAccessibleActionCount() {
                    return 1;
                }

                @Override
                public String getAccessibleActionDescription(int i) {
                    if (i == 0) {
                        return UIManager.getString("AbstractButton.clickText");
                    }
                    return null;
                }

                @Override
                public boolean doAccessibleAction(int i) {
                    if (i == 0) {
                        MyValueRenderer.this.myTable.editCellAt(MyValueRenderer.this.myRow, MyValueRenderer.this.myColumn);
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    protected static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final Option myKey;
        private final String myText;
        private Object myValue;

        public MyTreeNode(Option key, String text, CodeStyleSettings settings) {
            this.myKey = key;
            this.myText = text;
            this.myValue = key.getValue(settings);
            this.setUserObject(this.myText);
        }

        public Option getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public Object getValue() {
            return this.myValue;
        }

        public void setValue(Object value) {
            this.myValue = value;
        }

        public void reset(CodeStyleSettings settings) {
            this.setValue(this.myKey.getValue(settings));
        }

        public boolean isModified(CodeStyleSettings settings) {
            return this.myValue != null && !this.myValue.equals(this.myKey.getValue(settings));
        }

        public void apply(CodeStyleSettings settings) {
            this.myKey.setValue(this.myValue, settings);
        }

        public boolean isEnabled() {
            return this.myKey.isEnabled();
        }
    }

    private class IntOption
    extends FieldOption {
        private final int myMinValue;
        private final int myMaxValue;
        private final int myDefaultValue;
        @Nullable
        private final Function<? super Integer, String> myDefaultValueRenderer;

        IntOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName, int minValue, int maxValue, @Nullable int defaultValue, Function<? super Integer, String> defaultValueRenderer) {
            super(clazz, fieldName, title, groupName, anchor2, anchorFiledName);
            this.myMinValue = minValue;
            this.myMaxValue = maxValue;
            this.myDefaultValue = defaultValue;
            this.myDefaultValueRenderer = defaultValueRenderer;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                return this.field.getInt(this.getSettings(settings));
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            try {
                if (value instanceof Integer) {
                    this.field.setInt(this.getSettings(settings), (Integer)value);
                } else {
                    this.field.setInt(this.getSettings(settings), this.myDefaultValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public int getMinValue() {
            return this.myMinValue;
        }

        public int getMaxValue() {
            return this.myMaxValue;
        }

        public int getDefaultValue() {
            return this.myDefaultValue;
        }

        public boolean isDefaultValue(Object value) {
            return value instanceof Integer && (Integer)value == this.myDefaultValue;
        }

        @Nullable
        public String getDefaultValueText() {
            return this.myDefaultValueRenderer != null ? this.myDefaultValueRenderer.apply((Integer)this.myDefaultValue) : null;
        }
    }

    private class SelectionOption
    extends FieldOption {
        @NotNull
        final String[] options;
        @NotNull
        final int[] values;

        SelectionOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @NotNull String anchorFiledName, @NotNull String[] options, int[] values) {
            super(clazz, fieldName, title, groupName, anchor2, anchorFiledName);
            this.options = options;
            this.values = values;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                int value = this.field.getInt(this.getSettings(settings));
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] != value) continue;
                    return this.options[i];
                }
                LOG.error("Invalid option value " + value + " for " + this.field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    if (!this.options[i].equals(value)) continue;
                    this.field.setInt(this.getSettings(settings), this.values[i]);
                    return;
                }
                LOG.error("Invalid option value " + value + " for " + this.field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private class BooleanOption
    extends FieldOption {
        private BooleanOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName) {
            super(clazz, fieldName, title, groupName, anchor2, anchorFiledName);
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                return this.field.getBoolean(this.getSettings(settings));
            }
            catch (IllegalAccessException ignore) {
                return null;
            }
        }

        @Override
        public void setValue(Object value, CodeStyleSettings settings) {
            try {
                this.field.setBoolean(this.getSettings(settings), (Boolean)value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private abstract class FieldOption
    extends Option {
        @Nullable
        final Class<? extends CustomCodeStyleSettings> clazz;
        @NotNull
        final Field field;

        FieldOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, String anchorFiledName) {
            super(fieldName, title, groupName, anchor2, anchorFiledName);
            this.clazz = clazz;
            try {
                Class styleSettingsClass = clazz == null ? CommonCodeStyleSettings.class : clazz;
                this.field = styleSettingsClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        protected Object getSettings(CodeStyleSettings settings) {
            if (this.clazz != null) {
                return settings.getCustomSettings(this.clazz);
            }
            return settings.getCommonSettings(OptionTableWithPreviewPanel.this.getDefaultLanguage());
        }
    }

    protected static abstract class Option
    extends CustomizableLanguageCodeStylePanel.OrderedOption {
        @NotNull
        final String title;
        @Nullable
        final String groupName;
        private boolean myEnabled = false;

        protected Option(@NotNull String optionName, @NotNull String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorOptionName) {
            super(optionName, anchor2, anchorOptionName);
            this.title = title;
            this.groupName = groupName;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public abstract Object getValue(CodeStyleSettings var1);

        public abstract void setValue(Object var1, CodeStyleSettings var2);
    }
}

