/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.application.options.codeStyle.arrangement.action.AbstractArrangementRuleAction;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.IconUtil;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoveArrangementRuleAction
extends AbstractArrangementRuleAction
implements DumbAware {
    public RemoveArrangementRuleAction() {
        this.getTemplatePresentation().setText(ApplicationBundle.message((String)"arrangement.action.rule.remove.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ApplicationBundle.message((String)"arrangement.action.rule.remove.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(IconUtil.getRemoveIcon());
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        e.getPresentation().setEnabled(control != null && !control.getSelectedModelRows().isEmpty() && control.getEditingRow() == -1);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null) {
            return;
        }
        control.hideEditor();
        TIntArrayList rowsToRemove = control.getSelectedModelRows();
        if (rowsToRemove.isEmpty()) {
            return;
        }
        ArrangementMatchingRulesModel model = control.getModel();
        control.runOperationIgnoreSelectionChange(() -> {
            for (int i = 0; i < rowsToRemove.size(); ++i) {
                int row2 = rowsToRemove.get(i);
                model.removeRow(row2);
            }
        });
    }
}

