/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.animation;

import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementAnimationPanel
extends JPanel {
    @NotNull
    private final JComponent myContent;
    private int myAnimationIterationStep;
    @Nullable
    private BufferedImage myImage;
    @Nullable
    private BufferedImage myCurrentImage;
    @Nullable
    private Listener myListener;
    private final boolean myExpand;
    private final boolean myHorizontal;
    private boolean myDelayedAnimation;
    private boolean myAnimated;

    public ArrangementAnimationPanel(@NotNull JComponent content, boolean expand, boolean horizontal) {
        super(new GridBagLayout());
        this.myContent = content;
        this.myExpand = expand;
        this.myHorizontal = horizontal;
        this.add((Component)content, new GridBag().fillCell().weightx(1.0).weighty(1.0));
        this.setOpaque(false);
        this.setBackground(UIUtil.getListBackground());
        this.doLayout();
    }

    public void startAnimation() {
        this.myDelayedAnimation = true;
    }

    private void prepareForAnimation() {
        Dimension size = this.myContent.getPreferredSize();
        Rectangle bounds2 = this.myContent.getBounds();
        ArrangementAnimationPanel.applyDoubledBuffered(this.myContent, false);
        this.myContent.setBounds(0, 0, size.width, size.height);
        this.myContent.validate();
        this.myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D graphics = this.myImage.createGraphics();
        UISettings.setupAntialiasing((Graphics)graphics);
        graphics.setClip(0, 0, size.width, size.height);
        graphics.setColor(UIUtil.getListBackground());
        graphics.fillRect(0, 0, size.width, size.height);
        this.myContent.paint(graphics);
        graphics.dispose();
        int expectedDurationMillis = 500;
        this.myAnimationIterationStep = Math.max((this.myHorizontal ? size.width : size.height) / (expectedDurationMillis / 40), 1);
        this.myContent.setBounds(bounds2);
        ArrangementAnimationPanel.applyDoubledBuffered(this.myContent, true);
        this.myCurrentImage = this.myExpand ? (this.myHorizontal ? this.myImage.getSubimage(0, 0, this.myAnimationIterationStep, this.myImage.getHeight()) : this.myImage.getSubimage(0, 0, this.myImage.getWidth(), this.myAnimationIterationStep)) : (this.myHorizontal ? this.myImage.getSubimage(0, 0, this.myImage.getWidth() - this.myAnimationIterationStep, this.myImage.getHeight()) : this.myImage.getSubimage(0, 0, this.myImage.getWidth(), this.myImage.getHeight() - this.myAnimationIterationStep));
        this.invalidate();
    }

    private static void applyDoubledBuffered(JComponent component, boolean doubleBuffered) {
        component.setDoubleBuffered(doubleBuffered);
        for (int i = 0; i < component.getComponentCount(); ++i) {
            ArrangementAnimationPanel.applyDoubledBuffered((JComponent)component.getComponent(i), doubleBuffered);
        }
    }

    public boolean nextIteration() {
        int widthToUse = this.getImageWidthToUse();
        int heightToUse = this.getImageHeightToUse();
        if (widthToUse <= 0 || heightToUse <= 0) {
            this.myImage = null;
            this.myCurrentImage = null;
            this.myAnimated = true;
            return false;
        }
        this.myCurrentImage = this.myImage.getSubimage(0, 0, widthToUse, heightToUse);
        this.invalidate();
        return true;
    }

    @Override
    public void paint(Graphics g) {
        if (this.myDelayedAnimation) {
            this.prepareForAnimation();
            this.myDelayedAnimation = false;
        }
        if (this.myCurrentImage == null) {
            super.paint(g);
            return;
        }
        g.drawImage(this.myCurrentImage, 0, 0, this.myCurrentImage.getWidth(), this.myCurrentImage.getHeight(), null);
        if (this.myListener != null) {
            this.myListener.onPaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myAnimated) {
            return this.myContent.getPreferredSize();
        }
        if (this.myCurrentImage == null) {
            Dimension size = this.myContent.getPreferredSize();
            int width = this.myHorizontal && this.myExpand ? this.myAnimationIterationStep : size.width;
            int height = !this.myHorizontal && this.myExpand ? this.myAnimationIterationStep : size.height;
            return new Dimension(width, height);
        }
        return new Dimension(this.myCurrentImage.getWidth(), this.myCurrentImage.getHeight());
    }

    private int getImageWidthToUse() {
        assert (this.myCurrentImage != null);
        if (!this.myHorizontal) {
            return this.myCurrentImage.getWidth();
        }
        int sign = this.myExpand ? 1 : -1;
        int result2 = this.myCurrentImage.getWidth() + sign * this.myAnimationIterationStep;
        if (result2 <= 0 || result2 > this.myImage.getWidth()) {
            return -1;
        }
        return result2;
    }

    private int getImageHeightToUse() {
        assert (this.myCurrentImage != null);
        if (this.myHorizontal) {
            return this.myCurrentImage.getHeight();
        }
        int sign = this.myExpand ? 1 : -1;
        int result2 = this.myCurrentImage.getHeight() + sign * this.myAnimationIterationStep;
        if (result2 <= 0 || result2 > this.myImage.getHeight()) {
            return -1;
        }
        return result2;
    }

    public void setListener(@Nullable Listener listener2) {
        this.myListener = listener2;
    }

    @Override
    public String toString() {
        return "animation panel for " + this.myContent.toString();
    }

    public static interface Listener {
        public void onPaint();
    }
}

