/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.component.AbstractArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ArrangementCheckBoxUiComponent
extends AbstractArrangementUiComponent {
    @NotNull
    private final JPanel myComponent = new JPanel(new GridBagLayout());
    @NotNull
    private final ArrangementAtomMatchCondition myCondition;
    @NotNull
    private final JBCheckBox myCheckBox;
    @NotNull
    private final JLabel myTextLabel;

    public ArrangementCheckBoxUiComponent(@NotNull ArrangementSettingsToken token) {
        super(token);
        this.myComponent.setOpaque(false);
        this.myCondition = new ArrangementAtomMatchCondition(token);
        this.myCheckBox = new JBCheckBox();
        this.myCheckBox.setOpaque(false);
        this.myTextLabel = new JLabel(token.getRepresentationValue());
        this.myCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ArrangementCheckBoxUiComponent.this.myTextLabel.setEnabled(ArrangementCheckBoxUiComponent.this.myCheckBox.isEnabled());
                ArrangementCheckBoxUiComponent.this.fireStateChanged();
            }
        });
        this.myTextLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ArrangementCheckBoxUiComponent.this.myCheckBox.setSelected(!ArrangementCheckBoxUiComponent.this.myCheckBox.isSelected());
            }
        });
        this.myComponent.add((Component)this.myCheckBox, new GridBag().anchor(17).insets(0, 0, 0, 2));
        this.myComponent.add((Component)this.myTextLabel, new GridBag().anchor(17).insets(0, 0, 0, 5));
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        return this.myCondition.getType();
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws UnsupportedOperationException {
        if (!this.getToken().equals((Object)data)) {
            throw new UnsupportedOperationException(String.format("Can't choose '%s' data at the check box token with data '%s'", data, this.getToken()));
        }
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        return this.myCondition;
    }

    @Override
    protected JComponent doGetUiComponent() {
        return this.myComponent;
    }

    @Override
    protected void doReset() {
    }

    @Override
    public boolean isEnabled() {
        return this.myCheckBox.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myCheckBox.setEnabled(enabled);
    }

    public boolean isSelected() {
        return this.myCheckBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.myCheckBox.setSelected(selected);
    }

    public int getBaselineToUse(int width, int height) {
        return this.myTextLabel.getBaseline(width, height);
    }

    public void handleMouseClickOnSelected() {
        this.setSelected(false);
    }
}

