/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.animation.ArrangementAnimationManager;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.CalloutBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ArrangementEditorComponent
implements ArrangementRepresentationAware,
ArrangementAnimationManager.Callback,
ArrangementEditorAware {
    @NotNull
    private final ArrangementMatchingRulesControl myList;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final Insets myBorderInsets;
    @NotNull
    private final ArrangementMatchingRuleEditor myEditor;
    private final int myRow;

    public ArrangementEditorComponent(@NotNull ArrangementMatchingRulesControl list2, int row2, @NotNull ArrangementMatchingRuleEditor editor) {
        this.myList = list2;
        this.myRow = row2;
        this.myEditor = editor;
        JPanel borderPanel = new JPanel(new BorderLayout()){

            @Override
            public String toString() {
                return "callout border panel for " + ArrangementEditorComponent.this.myEditor;
            }
        };
        borderPanel.setBackground(UIUtil.getListBackground());
        borderPanel.add(editor);
        CalloutBorder border = new CalloutBorder();
        borderPanel.setBorder(border);
        this.myBorderInsets = border.getBorderInsets(borderPanel);
        this.myComponent = borderPanel;
        this.myList.repaintRows(this.myRow, this.myList.getModel().getSize() - 1, true);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    public void expand() {
    }

    @Override
    public void onAnimationIteration(boolean finished2) {
        this.myList.repaintRows(this.myRow, this.myList.getModel().getSize() - 1, false);
    }

    public void applyAvailableWidth(int width) {
        this.myEditor.applyAvailableWidth(width - this.myBorderInsets.left - this.myBorderInsets.right);
    }
}

