/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MultiRowFlowPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementMatchingRuleEditor
extends JPanel
implements ArrangementUiComponent.Listener {
    @NotNull
    private final Map<ArrangementSettingsToken, ArrangementUiComponent> myComponents = ContainerUtilRt.newHashMap();
    @NotNull
    private final List<MultiRowFlowPanel> myRows = ContainerUtilRt.newArrayList();
    @NotNull
    private final ArrangementMatchingRulesControl myControl;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    private int myRow = -1;
    private int myLabelWidth;
    @Nullable
    private JComponent myDefaultFocusRequestor;
    @Nullable
    private JComponent myFocusRequestor;
    private boolean mySkipStateChange;

    public ArrangementMatchingRuleEditor(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl control) {
        this(settingsManager, settingsManager.getSupportedMatchingTokens(), colorsProvider, control);
    }

    public ArrangementMatchingRuleEditor(@NotNull ArrangementStandardSettingsManager settingsManager, @Nullable List<? extends CompositeArrangementSettingsToken> tokens, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl control) {
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
        this.myControl = control;
        this.init(tokens);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ArrangementMatchingRuleEditor.this.onMouseClicked(e);
            }
        });
    }

    private void init(@Nullable List<? extends CompositeArrangementSettingsToken> tokens) {
        this.setLayout(new GridBagLayout());
        this.setBorder(JBUI.Borders.empty((int)5));
        if (tokens != null) {
            for (CompositeArrangementSettingsToken compositeArrangementSettingsToken : tokens) {
                this.addToken(compositeArrangementSettingsToken);
            }
        }
        this.applyBackground(UIUtil.getListBackground());
    }

    private void addToken(@NotNull CompositeArrangementSettingsToken rowToken) {
        ArrangementUiComponent component;
        List tokens = ArrangementUtil.flatten((CompositeArrangementSettingsToken)rowToken);
        GridBag labelConstraints = new GridBag().anchor(18).insets(4, 0, 0, 0);
        MultiRowFlowPanel panel2 = new MultiRowFlowPanel(0, 5, 3);
        ArrayList prevTokens = ContainerUtilRt.newArrayList();
        StdArrangementTokenUiRole prevRole = null;
        block4: for (CompositeArrangementSettingsToken token : tokens) {
            StdArrangementTokenUiRole role = token.getRole();
            if (role != prevRole && !prevTokens.isEmpty()) {
                component = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)role, (List)prevTokens, (ArrangementColorsProvider)this.myColorsProvider, (ArrangementStandardSettingsManager)this.mySettingsManager);
                component.setListener((ArrangementUiComponent.Listener)this);
                for (ArrangementSettingsToken prevToken : prevTokens) {
                    this.myComponents.put(prevToken, component);
                }
                panel2.add((Component)component.getUiComponent());
                panel2 = this.addRowIfNecessary(panel2);
                prevRole = null;
                prevTokens.clear();
            }
            component = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)role, Collections.singletonList(token.getToken()), (ArrangementColorsProvider)this.myColorsProvider, (ArrangementStandardSettingsManager)this.mySettingsManager);
            component.setListener((ArrangementUiComponent.Listener)this);
            JComponent uiComponent = component.getUiComponent();
            switch (role) {
                case LABEL: {
                    panel2 = this.addRowIfNecessary(panel2);
                    this.add((Component)uiComponent, labelConstraints);
                    this.myLabelWidth = Math.max(this.myLabelWidth, uiComponent.getPreferredSize().width);
                    prevRole = null;
                    continue block4;
                }
                case TEXT_FIELD: {
                    panel2 = this.addRowIfNecessary(panel2);
                    ArrangementUiComponent textLabel = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)StdArrangementTokenUiRole.LABEL, Collections.singletonList(token.getToken()), (ArrangementColorsProvider)this.myColorsProvider, (ArrangementStandardSettingsManager)this.mySettingsManager);
                    JComponent textLabelComponent = textLabel.getUiComponent();
                    this.add((Component)textLabelComponent, labelConstraints);
                    this.myLabelWidth = Math.max(this.myLabelWidth, textLabelComponent.getPreferredSize().width);
                    panel2.add((Component)uiComponent);
                    panel2 = this.addRowIfNecessary(panel2);
                    prevRole = null;
                    this.myComponents.put(token.getToken(), component);
                    if (this.myDefaultFocusRequestor != null) continue block4;
                    this.myDefaultFocusRequestor = uiComponent;
                    continue block4;
                }
            }
            if (role == StdArrangementTokenUiRole.COMBO_BOX) {
                prevTokens.add(token.getToken());
                prevRole = role;
                continue;
            }
            panel2.add((Component)uiComponent);
            this.myComponents.put(token.getToken(), component);
        }
        if (prevRole != null && !prevTokens.isEmpty()) {
            component = ArrangementUtil.buildUiComponent(prevRole, (List)prevTokens, (ArrangementColorsProvider)this.myColorsProvider, (ArrangementStandardSettingsManager)this.mySettingsManager);
            panel2.add((Component)component.getUiComponent());
            component.setListener((ArrangementUiComponent.Listener)this);
            for (ArrangementSettingsToken prevToken : prevTokens) {
                this.myComponents.put(prevToken, component);
            }
        }
        this.addRowIfNecessary(panel2);
    }

    @NotNull
    private MultiRowFlowPanel addRowIfNecessary(@NotNull MultiRowFlowPanel panel2) {
        if (panel2.getComponentCount() <= 0) {
            return panel2;
        }
        this.add((Component)panel2, new GridBag().anchor(17).weightx(1.0).fillCellHorizontally().coverLine());
        this.myRows.add(panel2);
        return new MultiRowFlowPanel(0, 5, 3);
    }

    public void stateChanged() {
        if (!this.mySkipStateChange) {
            this.apply();
        }
    }

    @Nullable
    private Pair<ArrangementMatchCondition, ArrangementSettingsToken> buildCondition() {
        ArrayList conditions = ContainerUtilRt.newArrayList();
        ArrangementSettingsToken orderType = null;
        for (ArrangementUiComponent component : this.myComponents.values()) {
            if (!component.isEnabled() || !component.isSelected()) continue;
            ArrangementSettingsToken token = component.getToken();
            if (token != null && StdArrangementTokenType.ORDER.is(token)) {
                orderType = token;
                continue;
            }
            conditions.add(component.getMatchCondition());
        }
        if (!conditions.isEmpty()) {
            if (orderType == null) {
                orderType = StdArrangementTokens.Order.KEEP;
            }
            return Pair.create((Object)ArrangementUtil.combine((ArrangementMatchCondition[])conditions.toArray(new ArrangementMatchCondition[0])), (Object)orderType);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myFocusRequestor != null) {
            if (this.myFocusRequestor.isFocusOwner()) {
                this.myFocusRequestor = null;
            } else {
                this.myFocusRequestor.requestFocusInWindow();
            }
        }
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int row2) {
        Map conditionTokens;
        ArrangementMatchCondition condition;
        ArrangementSettingsToken orderType;
        this.myRow = row2;
        this.myFocusRequestor = this.myDefaultFocusRequestor;
        this.mySkipStateChange = true;
        try {
            for (ArrangementUiComponent component : this.myComponents.values()) {
                component.reset();
            }
        }
        finally {
            this.mySkipStateChange = false;
        }
        ArrangementMatchingRulesModel model = this.myControl.getModel();
        if (row2 < 0 || row2 >= model.getSize()) {
            this.myRow = -1;
            return;
        }
        Object element = model.getElementAt(row2);
        ArrangementSettingsToken arrangementSettingsToken = orderType = element instanceof ArrangementMatchRule ? ((ArrangementMatchRule)element).getOrderType() : null;
        if (element instanceof EmptyArrangementRuleComponent) {
            condition = null;
            conditionTokens = ContainerUtilRt.newHashMap();
        } else {
            if (!(element instanceof StdArrangementMatchRule)) {
                return;
            }
            condition = ((StdArrangementMatchRule)element).getMatcher().getCondition();
            conditionTokens = ArrangementUtil.extractTokens((ArrangementMatchCondition)condition);
        }
        this.mySkipStateChange = true;
        try {
            for (ArrangementUiComponent component : this.myComponents.values()) {
                Object value;
                ArrangementSettingsToken token = component.getToken();
                if (token == null || !component.getAvailableTokens().contains(orderType) && !this.isEnabled(condition, token)) continue;
                component.setEnabled(true);
                if (component.getAvailableTokens().contains(orderType)) {
                    component.chooseToken(orderType);
                } else {
                    component.setSelected(conditionTokens.containsKey(token));
                }
                if ((value = conditionTokens.get(token)) == null) continue;
                component.setData(value);
            }
            this.refreshConditions();
        }
        finally {
            this.mySkipStateChange = false;
        }
    }

    private void refreshConditions() {
        Pair<ArrangementMatchCondition, ArrangementSettingsToken> pair = this.buildCondition();
        ArrangementMatchCondition condition = (ArrangementMatchCondition)Pair.getFirst(pair);
        for (ArrangementUiComponent component : this.myComponents.values()) {
            ArrangementSettingsToken token = component.getToken();
            if (token == null) continue;
            boolean enabled = this.isEnabled(condition, token);
            component.setEnabled(enabled);
            if (enabled) continue;
            component.setSelected(false);
        }
    }

    private boolean isEnabled(@Nullable ArrangementMatchCondition condition, @NotNull ArrangementSettingsToken token) {
        return ArrangementSectionRuleManager.isEnabled(token) || this.mySettingsManager.isEnabled(token, condition);
    }

    private void apply() {
        Pair<ArrangementMatchCondition, ArrangementSettingsToken> pair = this.buildCondition();
        EmptyArrangementRuleComponent modelValue = pair == null ? new EmptyArrangementRuleComponent(this.myControl.getRowHeight(this.myRow)) : new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)pair.first), (ArrangementSettingsToken)pair.second);
        this.myControl.getModel().set(this.myRow, modelValue);
        this.myControl.repaintRows(this.myRow, this.myRow, true);
    }

    public void applyAvailableWidth(int width) {
        for (MultiRowFlowPanel row2 : this.myRows) {
            row2.setForcedWidth(width - this.myLabelWidth);
        }
        this.validate();
    }

    private void applyBackground(@NotNull Color color) {
        this.setBackground(color);
        for (JComponent jComponent : this.myRows) {
            jComponent.setBackground(color);
        }
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        if (this.myRow < 0) {
            return;
        }
        Point locationOnScreen = e.getLocationOnScreen();
        for (ArrangementUiComponent component : this.myComponents.values()) {
            Rectangle screenBounds = component.getScreenBounds();
            if (screenBounds == null || !screenBounds.contains(locationOnScreen)) continue;
            if (component.isEnabled()) {
                if (component.isSelected()) {
                    Set<ArrangementSettingsToken> mutexes = ArrangementSectionRuleManager.getSectionMutexes();
                    if (!mutexes.contains(component.getToken())) {
                        component.handleMouseClickOnSelected();
                        this.refreshConditions();
                    }
                } else {
                    this.addCondition(component);
                }
            }
            this.apply();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCondition(@NotNull ArrangementUiComponent component) {
        this.mySkipStateChange = true;
        try {
            component.setSelected(true);
            Collection mutexes = this.mySettingsManager.getMutexes();
            for (Set mutex : mutexes) {
                this.updateMutexConditions(component, mutex);
            }
            this.updateMutexConditions(component, ArrangementSectionRuleManager.getSectionMutexes());
            this.refreshConditions();
        }
        finally {
            this.mySkipStateChange = false;
        }
    }

    private void updateMutexConditions(@NotNull ArrangementUiComponent component, @NotNull Set<? extends ArrangementSettingsToken> mutex) {
        if (!mutex.contains(component.getToken())) {
            return;
        }
        for (ArrangementSettingsToken arrangementSettingsToken : mutex) {
            ArrangementUiComponent c;
            if (arrangementSettingsToken.equals((Object)component.getToken()) || (c = this.myComponents.get(arrangementSettingsToken)) == null || !c.isEnabled() || c.alwaysCanBeActive()) continue;
            this.removeCondition(c);
        }
    }

    private void removeCondition(@NotNull ArrangementUiComponent component) {
        component.setSelected(false);
        component.setData((Object)true);
        this.refreshConditions();
    }

    @Override
    public String toString() {
        return "matching rule editor";
    }
}

