/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.application.options.codeStyle.arrangement.util.TitleWithToolbar;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementMatchingRulesPanel
extends JPanel
implements DataProvider {
    @NotNull
    protected final ArrangementSectionRulesControl myControl;

    public ArrangementMatchingRulesPanel(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        super(new GridBagLayout());
        JBScrollPane scrollPane = new JBScrollPane();
        scrollPane.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
        final JViewport viewport = scrollPane.getViewport();
        ArrangementMatchingRulesControl.RepresentationCallback callback2 = new ArrangementMatchingRulesControl.RepresentationCallback(){

            @Override
            public void ensureVisible(@NotNull Rectangle r) {
                Rectangle visibleRect = viewport.getViewRect();
                if (r.y <= visibleRect.y) {
                    return;
                }
                int excessiveHeight = r.y + r.height - (visibleRect.y + visibleRect.height);
                if (excessiveHeight <= 0) {
                    return;
                }
                int verticalShift = Math.min(r.y - visibleRect.y, excessiveHeight);
                if (verticalShift > 0) {
                    viewport.setViewPosition(new Point(visibleRect.x, visibleRect.y + verticalShift));
                }
            }
        };
        this.myControl = this.createRulesControl(language, settingsManager, colorsProvider, callback2);
        scrollPane.setViewportView((Component)((Object)this.myControl));
        scrollPane.setViewportBorder((Border)JBUI.Borders.emptyRight((int)scrollPane.getVerticalScrollBar().getPreferredSize().width));
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myControl), "Arrangement.Rule.Match.Control.Context.Menu", "Arrangement.Rule.Match.Control.Place");
        TitleWithToolbar top = new TitleWithToolbar(ApplicationBundle.message((String)"arrangement.settings.section.match", (Object[])new Object[0]), "Arrangement.Rule.Match.Control.ToolBar", "Arrangement.Rule.Match.Control.ToolBar.Place", (JComponent)((Object)this.myControl));
        this.add((Component)top, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.add((Component)scrollPane, new GridBag().fillCell().weightx(1.0).weighty(1.0).insets(0, 8, 0, 0));
    }

    protected ArrangementSectionRulesControl createRulesControl(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl.RepresentationCallback callback2) {
        return new ArrangementSectionRulesControl(language, settingsManager, colorsProvider, callback2);
    }

    @NotNull
    public List<ArrangementSectionRule> getSections() {
        return this.myControl.getSections();
    }

    public void setSections(@Nullable List<ArrangementSectionRule> rules) {
        this.myControl.setSections(rules);
    }

    @Nullable
    public Collection<StdArrangementRuleAliasToken> getRulesAliases() {
        return this.myControl.getRulesAliases();
    }

    public void setRulesAliases(@Nullable Collection<StdArrangementRuleAliasToken> aliases) {
        this.myControl.setRulesAliases(aliases);
    }

    public void hideEditor() {
        this.myControl.hideEditor();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (ArrangementSectionRulesControl.KEY.is(dataId)) {
            return this.myControl;
        }
        return null;
    }
}

