/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match.tokens;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasesListEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementRuleAliasDialog
extends DialogWrapper {
    private final ArrangementRuleAliasesListEditor myEditor;
    private boolean myModified;

    public ArrangementRuleAliasDialog(@Nullable Project project, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull Collection<StdArrangementRuleAliasToken> tokens, @NotNull Set<String> tokensInUse) {
        super(project, false);
        ArrayList tokenList = ContainerUtil.newArrayList(tokens);
        this.myEditor = new ArrangementRuleAliasesListEditor(settingsManager, colorsProvider, tokenList, tokensInUse);
        if (!tokenList.isEmpty()) {
            this.myEditor.selectItem(tokenList.get(0));
        }
        this.setTitle(ApplicationBundle.message((String)"arrangement.settings.section.rule.custom.token.title", (Object[])new Object[0]));
        this.init();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public Collection<StdArrangementRuleAliasToken> getRuleAliases() {
        return this.myEditor.getItems();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myEditor.createComponent();
    }

    protected void doOKAction() {
        try {
            this.myModified = this.myEditor.isModified();
            if (this.myModified) {
                this.myEditor.apply();
            }
            super.doOKAction();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

