/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.formatting.fileSet.PatternDescriptor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExcludedFilesPatternForm {
    private JPanel myTopPanel;
    private JBTextField myPatternField;

    public ExcludedFilesPatternForm() {
        this.$$$setupUI$$$();
        int minWidth = JBUI.scale((int)400);
        int minHeight = this.myPatternField.getMinimumSize().height;
        this.myPatternField.setMinimumSize(new Dimension(minWidth, minHeight));
    }

    protected abstract void updateOnError();

    protected abstract void updateOnValue(@NotNull String var1);

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    public void setFileSpec(@NotNull String fileSpec) {
        ((PatternField)this.myPatternField).getValueEditor().setValue((Object)fileSpec);
    }

    public String getFileSpec() {
        return (String)((PatternField)this.myPatternField).getValueEditor().getValue();
    }

    private void createUIComponents() {
        this.myPatternField = new PatternField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBTextField jBTextField = this.myPatternField;
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.file.pattern"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class PatternField
    extends JBTextField {
        private final ValueEditor<String> myValueEditor;

        private PatternField() {
            this.myValueEditor = new TextFieldValueEditor<String>((JTextField)((Object)this), "Pattern", ""){

                @NotNull
                public String parseValue(@Nullable String text) throws InvalidDataException {
                    if (text != null && !PatternDescriptor.isValidPattern((String)text)) {
                        throw new InvalidDataException("Invalid pattern");
                    }
                    return text != null ? text : "";
                }

                public String valueToString(@NotNull String value) {
                    return value;
                }

                public boolean isValid(@NotNull String value) {
                    return PatternDescriptor.isValidPattern((String)value);
                }

                protected String validateTextOnChange(String text, DocumentEvent e) {
                    String err = super.validateTextOnChange(text, e);
                    if (!StringUtil.isEmpty((String)err)) {
                        ExcludedFilesPatternForm.this.updateOnError();
                    }
                    return err;
                }
            };
            this.myValueEditor.addListener((ValueEditor.Listener)new ValueEditor.Listener<String>(){

                public void valueChanged(@NotNull String newValue) {
                    ExcludedFilesPatternForm.this.updateOnValue(newValue);
                }
            });
        }

        public ValueEditor<String> getValueEditor() {
            return this.myValueEditor;
        }
    }
}

