/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.application.options.codeStyle.excludedFiles.ExcludedFilesDialogBase;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedFilesScopeForm;
import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.formatting.fileSet.NamedScopeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedFilesScopeDialog
extends ExcludedFilesDialogBase {
    private ExcludedFilesScopeForm myForm;
    private DefaultComboBoxModel<String> myScopeListModel;
    public static final int EDIT_SCOPES = 2;
    private final Action myEditAction;
    private final List<NamedScope> myAvailableScopes;

    protected ExcludedFilesScopeDialog(@NotNull Project project, @NotNull List<NamedScope> availableScopes) {
        super(project);
        this.myAvailableScopes = availableScopes;
        this.setTitle("Add Scope");
        this.myEditAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExcludedFilesScopeDialog.this.close(2);
            }
        };
        this.myEditAction.putValue("Name", "Edit Scopes...");
        this.init();
        this.fillScopesList(availableScopes);
    }

    private void fillScopesList(@NotNull List<NamedScope> availableScopes) {
        this.myScopeListModel = new DefaultComboBoxModel();
        for (NamedScope scope : availableScopes) {
            this.myScopeListModel.addElement(scope.getName());
        }
        this.myForm.getScopesList().setModel(this.myScopeListModel);
    }

    @Override
    @Nullable
    public FileSetDescriptor getDescriptor() {
        String scopeName;
        int selectedIndex = this.myForm.getScopesList().getSelectedIndex();
        String string = scopeName = selectedIndex >= 0 ? this.myScopeListModel.getElementAt(selectedIndex) : null;
        if (scopeName != null) {
            for (NamedScope scope : this.myAvailableScopes) {
                if (!scopeName.equals(scope.getName())) continue;
                return new NamedScopeDescriptor(scope);
            }
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myForm = new ExcludedFilesScopeForm();
        return this.myForm.getTopPanel();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.myEditAction};
    }
}

