/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontPanelFactoryEx;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.ConsoleFontOptions;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.application.options.colors.RainbowColorsInSchemeState;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.application.options.colors.ScopeColorsPageFactory;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.actions.QuickChangeColorSchemeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontOptions
extends SearchableConfigurable.Parent.Abstract
implements EditorOptionsProvider,
SchemesModel<EditorColorsScheme> {
    private static final Logger LOG = Logger.getInstance(ColorAndFontOptions.class);
    public static final String ID = "reference.settingsdialog.IDE.editor.colors";
    public static final String FONT_CONFIGURABLE_NAME = "Color Scheme Font";
    private Map<String, MyColorScheme> mySchemes;
    private MyColorScheme mySelectedScheme;
    public static final String SCOPES_GROUP = ApplicationBundle.message((String)"title.scope.based", (Object[])new Object[0]);
    private boolean mySomeSchemesDeleted = false;
    private Map<ColorAndFontPanelFactory, InnerSearchableConfigurable> mySubPanelFactories;
    private SchemesPanel myRootSchemesPanel;
    private boolean myInitResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertChangesCompleted = false;
    private boolean myApplyCompleted = false;
    private boolean myDisposeCompleted = false;
    private final Disposable myDisposable = Disposer.newDisposable();
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myIsReset = false;

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void stateChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean listModified = this.isSchemeListModified();
        boolean schemeModified = this.isSomeSchemeModified();
        if (listModified || schemeModified) {
            this.myApplyCompleted = false;
        }
        return listModified;
    }

    private boolean isSchemeListModified() {
        if (this.mySomeSchemesDeleted) {
            return true;
        }
        if (!this.mySelectedScheme.getName().equals(EditorColorsManager.getInstance().getGlobalScheme().getName())) {
            return true;
        }
        for (MyColorScheme scheme2 : this.mySchemes.values()) {
            if (!scheme2.isNew()) continue;
            return true;
        }
        return false;
    }

    private boolean isSomeSchemeModified() {
        for (MyColorScheme scheme2 : this.mySchemes.values()) {
            if (!scheme2.isModified()) continue;
            return true;
        }
        return false;
    }

    public EditorColorsScheme selectScheme(@NotNull String name) {
        this.mySelectedScheme = this.getScheme(name);
        return this.mySelectedScheme;
    }

    MyColorScheme getScheme(String name) {
        return this.mySchemes.get(name);
    }

    public EditorColorsScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public EditorSchemeAttributeDescriptor[] getCurrentDescriptions() {
        return this.mySelectedScheme.getDescriptors();
    }

    @Override
    public boolean canDuplicateScheme(@NotNull EditorColorsScheme scheme2) {
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull EditorColorsScheme scheme2) {
        AbstractColorsScheme originalScheme = scheme2 instanceof AbstractColorsScheme ? ((AbstractColorsScheme)scheme2).getOriginal() : null;
        return !ColorAndFontOptions.isReadOnly(scheme2) && scheme2.getName().startsWith("_@user_") && originalScheme instanceof ReadOnlyColorsScheme;
    }

    @Override
    public boolean canDeleteScheme(@NotNull EditorColorsScheme scheme2) {
        return !ColorAndFontOptions.isReadOnly(scheme2) && ColorAndFontOptions.canBeDeleted(scheme2);
    }

    @Override
    public boolean isProjectScheme(@NotNull EditorColorsScheme scheme2) {
        return false;
    }

    @Override
    public boolean canRenameScheme(@NotNull EditorColorsScheme scheme2) {
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean projectScheme) {
        assert (!projectScheme);
        return this.mySchemes.get(name) != null || this.mySchemes.get("_@user_" + name) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull EditorColorsScheme scheme2) {
        if (scheme2.getName().startsWith("_@user_")) {
            String displayName = SchemeManager.getDisplayName((Scheme)scheme2);
            EditorColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getScheme(displayName);
            if (defaultScheme == null) {
                defaultScheme = EditorColorsManager.getInstance().getScheme(displayName);
            }
            if (defaultScheme != null && scheme2 instanceof AbstractColorsScheme) {
                return !((AbstractColorsScheme)scheme2).settingsEqual(defaultScheme, colorKey -> !colorKey.getExternalName().startsWith("FILESTATUS_"));
            }
        }
        return false;
    }

    public static boolean isReadOnly(@NotNull EditorColorsScheme scheme2) {
        return ((MyColorScheme)scheme2).isReadOnly();
    }

    public static boolean canBeDeleted(@NotNull EditorColorsScheme scheme2) {
        return scheme2 instanceof MyColorScheme && ((MyColorScheme)scheme2).canBeDeleted();
    }

    @NotNull
    public Collection<EditorColorsScheme> getOrderedSchemes() {
        ArrayList<EditorColorsScheme> schemes = new ArrayList<EditorColorsScheme>(this.mySchemes.values());
        Collections.sort(schemes, EditorColorSchemesComparator.INSTANCE);
        return schemes;
    }

    @NotNull
    public Collection<EditorColorsScheme> getSchemes() {
        return new ArrayList<EditorColorsScheme>(this.mySchemes.values());
    }

    public boolean saveSchemeAs(@NotNull EditorColorsScheme editorScheme, @NotNull String name) {
        if (editorScheme instanceof MyColorScheme) {
            MyColorScheme scheme2 = (MyColorScheme)editorScheme;
            EditorColorsScheme clone = (EditorColorsScheme)scheme2.getParentScheme().clone();
            scheme2.apply(clone);
            if (clone instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)clone).setSaveNeeded(true);
            }
            clone.setName(name);
            MyColorScheme newScheme = new MyColorScheme(clone);
            ColorAndFontOptions.initScheme(newScheme);
            newScheme.setIsNew();
            this.mySchemes.put(name, newScheme);
            this.selectScheme(newScheme.getName());
            this.resetSchemesCombo(null);
            return true;
        }
        return false;
    }

    public void addImportedScheme(@NotNull EditorColorsScheme imported) {
        if (imported instanceof AbstractColorsScheme) {
            ((AbstractColorsScheme)imported).setSaveNeeded(true);
        }
        MyColorScheme newScheme = new MyColorScheme(imported);
        ColorAndFontOptions.initScheme(newScheme);
        this.mySchemes.put(imported.getName(), newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    @Override
    public void removeScheme(@NotNull EditorColorsScheme scheme2) {
        String schemeName = scheme2.getName();
        if (this.mySelectedScheme.getName().equals(schemeName)) {
            this.selectDefaultScheme();
        }
        boolean deletedNewlyCreated = false;
        MyColorScheme toDelete = this.mySchemes.get(schemeName);
        if (toDelete != null) {
            deletedNewlyCreated = toDelete.isNew();
        }
        this.mySchemes.remove(schemeName);
        this.resetSchemesCombo(null);
        this.mySomeSchemesDeleted = this.mySomeSchemesDeleted || !deletedNewlyCreated;
    }

    private void selectDefaultScheme() {
        DefaultColorsScheme defaultScheme = (DefaultColorsScheme)EditorColorsManager.getInstance().getScheme("Default");
        this.selectScheme(defaultScheme.getEditableCopyName());
    }

    void resetSchemeToOriginal(@NotNull String name) {
        MyColorScheme schemeToReset = this.mySchemes.get(name);
        schemeToReset.resetToOriginal();
        this.selectScheme(name);
        this.resetSchemesCombo(null);
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (this.myApplyCompleted) {
            return;
        }
        try {
            EditorColorsManager myColorsManager = EditorColorsManager.getInstance();
            SchemeManager<EditorColorsScheme> schemeManager2 = ((EditorColorsManagerImpl)myColorsManager).getSchemeManager();
            ArrayList<EditorColorsScheme> result2 = new ArrayList<EditorColorsScheme>(this.mySchemes.values().size());
            boolean activeSchemeModified = false;
            EditorColorsScheme activeOriginalScheme = this.mySelectedScheme.getParentScheme();
            for (MyColorScheme scheme2 : this.mySchemes.values()) {
                boolean isModified = scheme2.apply();
                if (isModified && !activeSchemeModified && activeOriginalScheme == scheme2.getParentScheme()) {
                    activeSchemeModified = true;
                }
                result2.add(scheme2.getParentScheme());
            }
            boolean refreshEditors = activeSchemeModified && schemeManager2.getActiveScheme() == activeOriginalScheme;
            schemeManager2.setSchemes(ColorAndFontOptions.includingInvisible(result2, schemeManager2), activeOriginalScheme);
            if (refreshEditors) {
                ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
            }
            QuickChangeColorSchemeAction.changeLafIfNecessary(activeOriginalScheme);
            this.reset();
        }
        finally {
            this.myApplyCompleted = true;
        }
    }

    private static List<EditorColorsScheme> includingInvisible(@NotNull List<EditorColorsScheme> schemeList, @NotNull SchemeManager<EditorColorsScheme> schemeManager2) {
        for (EditorColorsScheme scheme2 : schemeManager2.getAllSchemes()) {
            if (AbstractColorsScheme.isVisible(scheme2)) continue;
            schemeList.add(scheme2);
        }
        return schemeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSchemesCombo(Object source) {
        this.myIsReset = true;
        try {
            this.myRootSchemesPanel.resetSchemesCombo(source);
            if (this.mySubPanelFactories != null) {
                for (NewColorAndFontPanel subPartialConfigurable : this.getPanels()) {
                    subPartialConfigurable.reset(source);
                }
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent createComponent() {
        if (this.myRootSchemesPanel == null) {
            this.ensureSchemesPanel();
        }
        return this.myRootSchemesPanel;
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public Configurable[] buildConfigurables() {
        this.myDisposeCompleted = false;
        this.initAll();
        List<ColorAndFontPanelFactory> panelFactories = this.createPanelFactories();
        this.mySubPanelFactories = new LinkedHashMap<ColorAndFontPanelFactory, InnerSearchableConfigurable>(panelFactories.size());
        for (ColorAndFontPanelFactory panelFactory : panelFactories) {
            this.mySubPanelFactories.put(panelFactory, new InnerSearchableConfigurable(panelFactory));
        }
        return this.mySubPanelFactories.values().toArray(new Configurable[0]);
    }

    @NotNull
    private Set<NewColorAndFontPanel> getPanels() {
        HashSet<NewColorAndFontPanel> result2 = new HashSet<NewColorAndFontPanel>();
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            NewColorAndFontPanel panel2 = configurable.getSubPanelIfInitialized();
            if (panel2 == null) continue;
            result2.add(panel2);
        }
        return result2;
    }

    protected List<ColorAndFontPanelFactory> createPanelFactories() {
        ColorSettingsPage[] pages;
        ArrayList<ColorAndFontPanelFactoryEx> extensions = new ArrayList<ColorAndFontPanelFactoryEx>();
        extensions.add(new FontConfigurableFactory());
        extensions.add(new ConsoleFontConfigurableFactory());
        for (final ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            extensions.add(new ColorAndFontPanelFactoryEx(){

                @Override
                @NotNull
                public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                    SimpleEditorPreview preview2 = new SimpleEditorPreview(options, page);
                    return NewColorAndFontPanel.create(preview2, page.getDisplayName(), options, null, page);
                }

                @Override
                @NotNull
                public String getPanelDisplayName() {
                    return page.getDisplayName();
                }

                public DisplayPriority getPriority() {
                    if (page instanceof DisplayPrioritySortable) {
                        return ((DisplayPrioritySortable)page).getPriority();
                    }
                    return DisplayPriority.LANGUAGE_SETTINGS;
                }

                @Override
                @NotNull
                public Class<?> getOriginalClass() {
                    return page.getClass();
                }
            });
        }
        extensions.addAll(ColorAndFontPanelFactory.EP_NAME.getExtensionList());
        Collections.sort(extensions, (f1, f2) -> {
            if (f1 instanceof DisplayPrioritySortable) {
                if (!(f2 instanceof DisplayPrioritySortable)) return 1;
                int result1 = ((DisplayPrioritySortable)f1).getPriority().compareTo((Enum)((DisplayPrioritySortable)f2).getPriority());
                if (result1 == 0) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
                return result1;
            }
            if (!(f2 instanceof DisplayPrioritySortable)) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
            return -1;
        });
        ArrayList<ColorAndFontPanelFactory> result2 = new ArrayList<ColorAndFontPanelFactory>(extensions);
        result2.add(new ScopeColorsPageFactory());
        return result2;
    }

    private void initAll() {
        this.mySchemes = new THashMap();
        for (EditorColorsScheme allScheme : EditorColorsManager.getInstance().getAllSchemes()) {
            MyColorScheme schemeDelegate = new MyColorScheme(allScheme);
            ColorAndFontOptions.initScheme(schemeDelegate);
            this.mySchemes.put(schemeDelegate.getName(), schemeDelegate);
        }
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (EditorColorsManagerImpl.isTempScheme(globalScheme)) {
            MyTempColorScheme schemeDelegate = new MyTempColorScheme((AbstractColorsScheme)globalScheme);
            ColorAndFontOptions.initScheme(schemeDelegate);
            this.mySchemes.put(schemeDelegate.getName(), schemeDelegate);
        }
        this.mySelectedScheme = this.mySchemes.get(globalScheme.getName());
        assert (this.mySelectedScheme != null) : globalScheme.getName() + "; myschemes=" + this.mySchemes;
    }

    private static void initScheme(@NotNull MyColorScheme scheme2) {
        ArrayList descriptions = new ArrayList();
        ColorAndFontOptions.initPluggedDescriptions(descriptions, scheme2);
        ColorAndFontOptions.initScopesDescriptors(descriptions, scheme2);
        scheme2.setDescriptors(descriptions.toArray(new EditorSchemeAttributeDescriptor[0]));
    }

    private static void initPluggedDescriptions(@NotNull List<? super EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        ColorSettingsPage[] pages = ColorSettingsPages.getInstance().getRegisteredPages();
        for (ColorSettingsPage page : pages) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)page, descriptions, scheme2);
        }
        for (ColorAndFontDescriptorsProvider provider : ColorAndFontDescriptorsProvider.EP_NAME.getExtensionList()) {
            ColorAndFontOptions.initDescriptions(provider, descriptions, scheme2);
        }
    }

    private static void initDescriptions(@NotNull ColorAndFontDescriptorsProvider provider, @NotNull List<? super EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        String className = provider.getClass().getName();
        String group = provider.getDisplayName();
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors(provider);
        if (provider instanceof RainbowColorSettingsPage) {
            RainbowAttributeDescriptor d = new RainbowAttributeDescriptor(((RainbowColorSettingsPage)provider).getLanguage(), group, ApplicationBundle.message((String)"rainbow.option.panel.display.name", (Object[])new Object[0]), scheme2, scheme2.myRainbowState);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
        for (AttributesDescriptor descriptor : attributeDescriptors) {
            if (descriptor == null) {
                LOG.warn("Null attribute descriptor in " + className);
                continue;
            }
            SchemeTextAttributesDescription d = new SchemeTextAttributesDescription(descriptor.getDisplayName(), group, descriptor.getKey(), scheme2, null, null);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
        for (ColorDescriptor descriptor : provider.getColorDescriptors()) {
            if (descriptor == null) {
                LOG.warn("Null color descriptor in " + className);
                continue;
            }
            EditorSettingColorDescription d = new EditorSettingColorDescription(descriptor.getDisplayName(), group, descriptor.getKey(), descriptor.getKind(), scheme2);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
    }

    private static void initScopesDescriptors(@NotNull List<? super EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        Project[] projects;
        THashSet namedScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<NamedScope, NamedScopesHolder>>(){

            public int computeHashCode(@NotNull Pair<NamedScope, NamedScopesHolder> object) {
                return ((NamedScope)object.getFirst()).getName().hashCode();
            }

            public boolean equals(@NotNull Pair<NamedScope, NamedScopesHolder> o1, @NotNull Pair<NamedScope, NamedScopesHolder> o2) {
                return ((NamedScope)o1.getFirst()).getName().equals(((NamedScope)o2.getFirst()).getName());
            }
        });
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)project);
            List<Pair<NamedScope, NamedScopesHolder>> cachedScopes = validationManager.getScopeBasedHighlightingCachedScopes();
            namedScopes.addAll(cachedScopes);
        }
        ArrayList list2 = new ArrayList(namedScopes);
        Collections.sort(list2, (o1, o2) -> ((NamedScope)o1.getFirst()).getName().compareToIgnoreCase(((NamedScope)o2.getFirst()).getName()));
        for (Pair pair : list2) {
            NamedScope namedScope = (NamedScope)pair.getFirst();
            String name = namedScope.getName();
            TextAttributesKey textAttributesKey = ScopeAttributesUtil.getScopeTextAttributeKey(name);
            if (scheme2.getAttributes(textAttributesKey) == null) {
                scheme2.setAttributes(textAttributesKey, new TextAttributes());
            }
            NamedScopesHolder holder = (NamedScopesHolder)pair.getSecond();
            PackageSet value = namedScope.getValue();
            String toolTip = holder.getDisplayName() + (value == null ? "" : ": " + value.getText());
            descriptions.add((EditorSchemeAttributeDescriptor)new SchemeTextAttributesDescription(name, SCOPES_GROUP, textAttributesKey, scheme2, holder.getIcon(), toolTip));
        }
    }

    private void revertChanges() {
        if (this.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertChangesCompleted = false;
        }
        if (!this.myRevertChangesCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertChangesCompleted = true;
            }
        }
    }

    private void resetImpl() {
        this.mySomeSchemesDeleted = false;
        this.initAll();
        this.resetSchemesCombo(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myInitResetCompleted) return;
                this.ensureSchemesPanel();
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myInitResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revertChanges();
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myInitResetCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myInitResetCompleted = true;
            }
        }
    }

    private void ensureSchemesPanel() {
        if (this.myRootSchemesPanel == null) {
            this.myRootSchemesPanel = new SchemesPanel(this);
            this.myRootSchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(@NotNull Object source) {
                    if (!ColorAndFontOptions.this.myIsReset) {
                        ColorAndFontOptions.this.resetSchemesCombo(source);
                    }
                }
            });
        }
    }

    public void disposeUIResources() {
        block6: {
            try {
                if (this.myDisposeCompleted) break block6;
                try {
                    super.disposeUIResources();
                    Disposer.dispose((Disposable)this.myDisposable);
                }
                finally {
                    this.myDisposeCompleted = true;
                }
            }
            finally {
                this.mySubPanelFactories = null;
                this.myInitResetCompleted = false;
                this.myInitResetInvoked = false;
                this.myRevertChangesCompleted = false;
                this.myApplyCompleted = false;
                this.myRootSchemesPanel = null;
            }
        }
    }

    @NotNull
    public String getHelpTopic() {
        return ID;
    }

    public static void writeTempScheme(EditorColorsScheme colorsScheme) {
        Element scheme2 = new Element("scheme");
        ((AbstractColorsScheme)colorsScheme).writeExternal(scheme2);
        ColorAndFontOptions.writeTempScheme(scheme2, colorsScheme);
    }

    public static void writeTempScheme(Element scheme2, EditorColorsScheme parentScheme) {
        Path path = EditorColorsManagerImpl.getTempSchemeOriginalFilePath(parentScheme);
        if (path != null) {
            try {
                Element originalFile = JDOMUtil.load((File)path.toFile());
                scheme2.setName(originalFile.getName());
                for (Attribute attribute : originalFile.getAttributes()) {
                    scheme2.setAttribute(attribute.getName(), attribute.getValue());
                }
                parentScheme.readExternal(scheme2);
                scheme2.removeChild("metaInfo");
                Element metaInfo = originalFile.getChild("metaInfo");
                if (metaInfo != null) {
                    metaInfo = JDOMUtil.load((CharSequence)JDOMUtil.writeElement((Element)metaInfo));
                    scheme2.addContent(0, (Content)metaInfo);
                }
                JDOMUtil.write((Element)scheme2, (File)path.toFile());
                VirtualFileManager.getInstance().syncRefresh();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(@NotNull Class pageClass) {
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (Map.Entry<ColorAndFontPanelFactory, InnerSearchableConfigurable> entry : this.mySubPanelFactories.entrySet()) {
            if (!pageClass.isInstance(entry.getValue().createPanel().getSettingsPage())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String pageName) {
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            if (!configurable.getDisplayName().equals(pageName)) continue;
            return configurable;
        }
        return null;
    }

    @Nullable
    public NewColorAndFontPanel findPage(String pageName) {
        InnerSearchableConfigurable child2 = (InnerSearchableConfigurable)this.findSubConfigurable(pageName);
        return child2 == null ? null : child2.createPanel();
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search2, @NotNull String name) {
        return ColorAndFontOptions.selectOrEdit(context, search2, options -> options.findSubConfigurable(name));
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search2, @NotNull Class<?> type) {
        return ColorAndFontOptions.selectOrEdit(context, search2, options -> options.findSubConfigurable(type));
    }

    private static boolean selectOrEdit(DataContext context, String search2, Function<? super ColorAndFontOptions, ? extends SearchableConfigurable> function) {
        return ColorAndFontOptions.select(context, search2, function) || ColorAndFontOptions.edit(context, search2, function);
    }

    private static boolean select(DataContext context, String search2, Function<? super ColorAndFontOptions, ? extends SearchableConfigurable> function) {
        Settings settings = (Settings)Settings.KEY.getData(context);
        if (settings == null) {
            return false;
        }
        ColorAndFontOptions options = settings.find(ColorAndFontOptions.class);
        if (options == null) {
            return false;
        }
        SearchableConfigurable page = function.apply(options);
        if (page == null) {
            return false;
        }
        settings.select((Configurable)page, search2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean edit(DataContext context, String search2, Function<? super ColorAndFontOptions, ? extends SearchableConfigurable> function) {
        ColorAndFontOptions options = new ColorAndFontOptions();
        SearchableConfigurable page = function.apply(options);
        Configurable[] configurables = options.getConfigurables();
        try {
            if (page != null) {
                Runnable runnable2 = search2 == null ? null : page.enableSearch(search2);
                Window window = UIUtil.getWindow((Component)((Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context)));
                if (window != null) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)window, (Configurable)page, runnable2);
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Project)CommonDataKeys.PROJECT.getData(context), (Configurable)page, runnable2);
                }
            }
        }
        finally {
            for (Configurable configurable : configurables) {
                configurable.disposeUIResources();
            }
            options.disposeUIResources();
        }
        return page != null;
    }

    private class InnerSearchableConfigurable
    implements SearchableConfigurable,
    OptionsContainingConfigurable,
    Configurable.NoScroll {
        private NewColorAndFontPanel mySubPanel;
        private boolean mySubInitInvoked = false;
        @NotNull
        private final ColorAndFontPanelFactory myFactory;

        private InnerSearchableConfigurable(ColorAndFontPanelFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        @Nls
        public String getDisplayName() {
            return this.myFactory.getPanelDisplayName();
        }

        public NewColorAndFontPanel getSubPanelIfInitialized() {
            return this.mySubPanel;
        }

        private NewColorAndFontPanel createPanel() {
            if (this.mySubPanel == null) {
                this.mySubPanel = this.myFactory.createPanel(ColorAndFontOptions.this);
                this.mySubPanel.reset(this);
                this.mySubPanel.addSchemesListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(@NotNull Object source) {
                        if (!ColorAndFontOptions.this.myIsReset) {
                            ColorAndFontOptions.this.resetSchemesCombo(source);
                        }
                    }
                });
                this.mySubPanel.addDescriptionListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void fontChanged() {
                        for (NewColorAndFontPanel panel2 : ColorAndFontOptions.this.getPanels()) {
                            panel2.updatePreview();
                            panel2.updateSchemesPanel();
                        }
                    }
                });
            }
            return this.mySubPanel;
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.createPanel().getPanel();
        }

        public boolean isModified() {
            this.createPanel();
            for (MyColorScheme scheme2 : ColorAndFontOptions.this.mySchemes.values()) {
                if (this.mySubPanel.containsFontOptions()) {
                    if (!scheme2.isFontModified() && !scheme2.isConsoleFontModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
                for (EditorSchemeAttributeDescriptor descriptor : scheme2.getDescriptors()) {
                    if (!this.mySubPanel.contains(descriptor) || !descriptor.isModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            ColorAndFontOptions.this.apply();
        }

        public void reset() {
            if (!this.mySubInitInvoked) {
                if (!ColorAndFontOptions.this.myInitResetCompleted) {
                    ColorAndFontOptions.this.resetFromChild();
                }
                this.mySubInitInvoked = true;
            } else {
                ColorAndFontOptions.this.revertChanges();
            }
        }

        public void disposeUIResources() {
            if (this.mySubPanel != null) {
                this.mySubPanel.disposeUIResources();
                this.mySubPanel = null;
            }
        }

        @NotNull
        public String getId() {
            return ColorAndFontOptions.this.getId() + "." + this.getDisplayName();
        }

        public Runnable enableSearch(String option2) {
            return this.createPanel().showOption(option2);
        }

        @Override
        @NotNull
        public Set<String> processListOptions() {
            return this.createPanel().processListOptions();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            return this.myFactory.getOriginalClass();
        }

        @NotNull
        @NonNls
        public String toString() {
            return "Color And Fonts for " + this.getDisplayName();
        }
    }

    private static class MyTempColorScheme
    extends MyColorScheme {
        private MyTempColorScheme(@NotNull AbstractColorsScheme parentScheme) {
            super(parentScheme);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        protected boolean apply() {
            Element scheme2 = new Element("scheme");
            EditorColorsScheme parentScheme = this.getParentScheme();
            ((AbstractColorsScheme)parentScheme).writeExternal(scheme2);
            Element changes2 = new Element("scheme");
            this.writeExternal(changes2);
            MyTempColorScheme.deepMerge(scheme2, changes2);
            ColorAndFontOptions.writeTempScheme(scheme2, parentScheme);
            return true;
        }

        private static void deepMerge(Element to, Element from) {
            List children2 = from.getChildren();
            Map<Pair<String, String>, Element> index = MyTempColorScheme.createNamedIndex(to);
            if (children2.isEmpty()) {
                Pair<String, String> key = MyTempColorScheme.indexKey(from);
                Element el = index.get(key);
                Parent parent = to.getParent();
                if (el == null && parent != null) {
                    if (!"".equals(from.getAttributeValue("value"))) {
                        parent.addContent((Content)from.clone());
                    }
                    parent.removeContent((Content)to);
                }
            } else {
                for (Element child2 : children2) {
                    Element el = index.get(MyTempColorScheme.indexKey(child2));
                    if (el != null) {
                        MyTempColorScheme.deepMerge(el, child2);
                        continue;
                    }
                    to.addContent(child2.clone());
                }
            }
        }

        private static Map<Pair<String, String>, Element> createNamedIndex(Element e) {
            HashMap<Pair<String, String>, Element> index = new HashMap<Pair<String, String>, Element>();
            for (Element child2 : e.getChildren()) {
                index.put(MyTempColorScheme.indexKey(child2), child2);
            }
            return index;
        }

        @NotNull
        private static Pair<String, String> indexKey(Element e) {
            return Pair.create((Object)e.getName(), (Object)e.getAttributeValue("name"));
        }
    }

    private static class MyColorScheme
    extends EditorColorsSchemeImpl {
        private EditorSchemeAttributeDescriptor[] myDescriptors;
        private String myName;
        private boolean myIsNew = false;
        private final RainbowColorsInSchemeState myRainbowState;
        private static final Predicate<ColorKey> FILE_STATUS_COLORS = input -> input != null && input.getExternalName().startsWith("FILESTATUS_");

        private MyColorScheme(@NotNull EditorColorsScheme parentScheme) {
            super(parentScheme);
            if (parentScheme.isUseEditorFontPreferencesInConsole()) {
                this.setUseEditorFontPreferencesInConsole();
            } else {
                this.setConsoleFontPreferences(parentScheme.getConsoleFontPreferences());
            }
            if (parentScheme.isUseAppFontPreferencesInEditor()) {
                this.setUseAppFontPreferencesInEditor();
            } else {
                this.setFontPreferences(parentScheme.getFontPreferences());
            }
            this.setQuickDocFontSize(parentScheme.getQuickDocFontSize());
            this.myName = parentScheme.getName();
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)this, (SchemeMetaInfo)parentScheme);
            this.myRainbowState = new RainbowColorsInSchemeState(this, parentScheme);
            this.initFonts();
        }

        @Override
        @Nullable
        public AbstractColorsScheme getOriginal() {
            return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getOriginal() : null;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        public void setName(@NotNull String name) {
            this.myName = name;
        }

        public void setDescriptors(EditorSchemeAttributeDescriptor[] descriptors) {
            this.myDescriptors = descriptors;
        }

        public EditorSchemeAttributeDescriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        @Override
        public boolean isReadOnly() {
            return this.myParentScheme instanceof ReadOnlyColorsScheme;
        }

        public boolean isModified() {
            if (this.isFontModified() || this.isConsoleFontModified()) {
                return true;
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canBeDeleted() {
            return this.myParentScheme instanceof AbstractColorsScheme && ((AbstractColorsScheme)this.myParentScheme).canBeDeleted();
        }

        private boolean isFontModified() {
            return !MyColorScheme.areDelegatingOrEqual(this.getFontPreferences(), this.myParentScheme.getFontPreferences());
        }

        private boolean isConsoleFontModified() {
            return !MyColorScheme.areDelegatingOrEqual(this.getConsoleFontPreferences(), this.myParentScheme.getConsoleFontPreferences());
        }

        protected boolean apply() {
            if (!(this.myParentScheme instanceof ReadOnlyColorsScheme)) {
                return this.apply(this.myParentScheme);
            }
            return false;
        }

        private boolean apply(@NotNull EditorColorsScheme scheme2) {
            boolean isModified;
            boolean bl = isModified = this.isFontModified() || this.isConsoleFontModified();
            if (this.isUseAppFontPreferencesInEditor()) {
                scheme2.setUseAppFontPreferencesInEditor();
            } else {
                scheme2.setFontPreferences(this.getFontPreferences());
            }
            if (this.isUseEditorFontPreferencesInConsole()) {
                scheme2.setUseEditorFontPreferencesInConsole();
            } else {
                scheme2.setConsoleFontPreferences(this.getConsoleFontPreferences());
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                isModified = true;
                descriptor.apply(scheme2);
            }
            if (isModified && scheme2 instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)scheme2).setSaveNeeded(true);
            }
            return isModified;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void setIsNew() {
            this.myIsNew = true;
        }

        public boolean isNew() {
            return this.myIsNew;
        }

        @Override
        @NotNull
        public String toString() {
            return "temporary scheme for " + this.myName;
        }

        public boolean isInherited(@NotNull TextAttributesKey key) {
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null) {
                TextAttributes ownAttrs;
                if (this.myParentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key)) != null) {
                    return ownAttrs == AbstractColorsScheme.INHERITED_ATTRS_MARKER;
                }
                TextAttributes attributes = this.getAttributes(key);
                if (attributes != null) {
                    TextAttributes fallbackAttributes = this.getAttributes(fallbackKey);
                    return attributes == fallbackAttributes;
                }
            }
            return false;
        }

        public boolean isInherited(ColorKey key) {
            ColorKey fallbackKey = key.getFallbackColorKey();
            if (fallbackKey != null) {
                Color ownAttrs;
                if (this.myParentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key)) != null) {
                    return ownAttrs == AbstractColorsScheme.INHERITED_COLOR_MARKER;
                }
                Color attributes = this.getColor(key);
                if (attributes != null) {
                    Color fallback = this.getColor(fallbackKey);
                    return attributes == fallback;
                }
            }
            return false;
        }

        public void resetToOriginal() {
            AbstractColorsScheme originalScheme;
            if (this.myParentScheme instanceof AbstractColorsScheme && (originalScheme = ((AbstractColorsScheme)this.myParentScheme).getOriginal()) != null) {
                MyColorScheme.copyPreservingFileStatusColors(originalScheme, (AbstractColorsScheme)this.myParentScheme);
                MyColorScheme.copyPreservingFileStatusColors(originalScheme, this);
                ColorAndFontOptions.initScheme(this);
            }
        }

        private static void copyPreservingFileStatusColors(@NotNull AbstractColorsScheme source, @NotNull AbstractColorsScheme target2) {
            Map fileStatusColors = target2.getColorKeys().stream().filter(FILE_STATUS_COLORS).collect(Collectors.toMap(Function.identity(), target2::getDirectlyDefinedColor));
            source.copyTo(target2);
            for (ColorKey key : fileStatusColors.keySet()) {
                target2.setColor(key, fileStatusColors.get(key));
            }
            target2.setSaveNeeded(true);
        }
    }

    private static class EditorSettingColorDescription
    extends ColorAndFontDescription {
        private final ColorKey myColorKey;
        private final ColorDescriptor.Kind myKind;
        private final Color myInitialColor;
        private Color myColor;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorAndFontDescriptorsProvider, ColorDescriptor> myBaseAttributeDescriptor;
        private final boolean myIsInheritedInitial;

        EditorSettingColorDescription(String name, String group, @NotNull ColorKey colorKey, @NotNull ColorDescriptor.Kind kind, @NotNull MyColorScheme scheme2) {
            super(name, group, colorKey.getExternalName(), scheme2, null, null);
            this.myColorKey = colorKey;
            this.myKind = kind;
            ColorKey fallbackKey = this.myColorKey.getFallbackColorKey();
            Color fallbackColor = null;
            if (fallbackKey != null) {
                fallbackColor = scheme2.getColor(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getColorDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = Pair.create(null, (Object)new ColorDescriptor(fallbackKey.getExternalName(), fallbackKey, this.myKind));
                }
                this.myFallbackAttributes = new TextAttributes(this.myKind == ColorDescriptor.Kind.FOREGROUND ? fallbackColor : null, this.myKind == ColorDescriptor.Kind.BACKGROUND ? fallbackColor : null, null, null, 0);
            }
            this.myColor = scheme2.getColor(this.myColorKey);
            this.myInitialColor = (Color)ObjectUtils.chooseNotNull((Object)fallbackColor, (Object)this.myColor);
            this.myIsInheritedInitial = scheme2.isInherited(this.myColorKey);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial) {
                // empty if block
            }
            this.initCheckedStatus();
        }

        @Override
        public int getFontType() {
            return 0;
        }

        @Override
        public void setFontType(int type) {
        }

        @Override
        public Color getExternalEffectColor() {
            return null;
        }

        @Override
        public void setExternalEffectColor(Color color) {
        }

        @Override
        public void setExternalEffectType(EffectType type) {
        }

        @Override
        @NotNull
        public EffectType getExternalEffectType() {
            return EffectType.LINE_UNDERSCORE;
        }

        @Override
        public Color getExternalForeground() {
            return this.myKind == ColorDescriptor.Kind.FOREGROUND ? this.myColor : null;
        }

        @Override
        public void setExternalForeground(Color col) {
            if (this.myKind != ColorDescriptor.Kind.FOREGROUND) {
                return;
            }
            if (this.myColor != null && this.myColor.equals(col)) {
                return;
            }
            this.myColor = col;
        }

        @Override
        public Color getExternalBackground() {
            return this.myKind == ColorDescriptor.Kind.BACKGROUND ? this.myColor : null;
        }

        @Override
        public void setExternalBackground(Color col) {
            if (this.myKind != ColorDescriptor.Kind.BACKGROUND) {
                return;
            }
            if (this.myColor != null && this.myColor.equals(col)) {
                return;
            }
            this.myColor = col;
        }

        @Override
        public Color getExternalErrorStripe() {
            return null;
        }

        @Override
        public void setExternalErrorStripe(Color col) {
        }

        @Override
        public boolean isFontEnabled() {
            return false;
        }

        @Override
        public boolean isForegroundEnabled() {
            return this.myKind == ColorDescriptor.Kind.FOREGROUND;
        }

        @Override
        public boolean isBackgroundEnabled() {
            return this.myKind == ColorDescriptor.Kind.BACKGROUND;
        }

        @Override
        public boolean isEffectsColorEnabled() {
            return false;
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialColor, (Object)this.myColor) || this.myIsInheritedInitial;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        public void apply(EditorColorsScheme scheme2) {
            boolean skip;
            if (scheme2 == null) {
                scheme2 = this.getScheme();
            }
            boolean bl = skip = scheme2 instanceof EditorColorsSchemeImpl && this.isInherited() && this.myIsInheritedInitial;
            if (!skip) {
                scheme2.setColor(this.myColorKey, this.isInherited() ? AbstractColorsScheme.INHERITED_COLOR_MARKER : this.myColor);
            }
        }

        @Override
        @Nullable
        public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
            return this.myBaseAttributeDescriptor;
        }
    }

    private static class SchemeTextAttributesDescription
    extends TextAttributesDescription {
        @NotNull
        private final TextAttributes myInitialAttributes;
        @NotNull
        private final TextAttributesKey key;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor> myBaseAttributeDescriptor;
        private final boolean myIsInheritedInitial;

        private SchemeTextAttributesDescription(String name, String group, @NotNull TextAttributesKey key, @NotNull MyColorScheme scheme2, Icon icon, String toolTip) {
            super(name, group, SchemeTextAttributesDescription.getInitialAttributes(scheme2, key).clone(), key, scheme2, icon, toolTip);
            this.key = key;
            this.myInitialAttributes = SchemeTextAttributesDescription.getInitialAttributes(scheme2, key);
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null) {
                this.myFallbackAttributes = scheme2.getAttributes(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getAttributeDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = new Pair(null, (Object)new AttributesDescriptor(fallbackKey.getExternalName(), fallbackKey));
                }
            }
            this.myIsInheritedInitial = scheme2.isInherited(key);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial && this.myFallbackAttributes != null) {
                this.getTextAttributes().copyFrom(this.myFallbackAttributes);
            }
            this.initCheckedStatus();
        }

        @NotNull
        private static TextAttributes getInitialAttributes(@NotNull MyColorScheme scheme2, @NotNull TextAttributesKey key) {
            TextAttributes attributes = scheme2.getAttributes(key);
            return attributes != null ? attributes : new TextAttributes();
        }

        public void apply(EditorColorsScheme scheme2) {
            boolean skip;
            if (scheme2 == null) {
                scheme2 = this.getScheme();
            }
            boolean bl = skip = scheme2 instanceof EditorColorsSchemeImpl && this.isInherited() && this.myIsInheritedInitial;
            if (!skip) {
                scheme2.setAttributes(this.key, this.isInherited() ? AbstractColorsScheme.INHERITED_ATTRS_MARKER : this.getTextAttributes());
            }
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialAttributes, (Object)this.getTextAttributes()) || this.myIsInheritedInitial;
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        @Override
        @Nullable
        public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
            return this.myBaseAttributeDescriptor;
        }
    }

    private static class ConsoleFontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private ConsoleFontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            FontEditorPreview previewPanel = new FontEditorPreview(() -> options.getSelectedScheme(), false){

                @Override
                protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
                    return ConsoleViewUtil.updateConsoleColorScheme(selectedScheme);
                }
            };
            return new NewColorAndFontPanel(new SchemesPanel(options, 0), new ConsoleFontOptions(options), previewPanel, "Font", null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            return "Console Font";
        }

        @NotNull
        public DisplayPriority getPriority() {
            return DisplayPriority.FONT_SETTINGS;
        }
    }

    private static class FontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private FontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            FontEditorPreview previewPanel = new FontEditorPreview(() -> options.getSelectedScheme(), true);
            return new NewColorAndFontPanel(new SchemesPanel(options, 0), new FontOptions(options), previewPanel, ColorAndFontOptions.FONT_CONFIGURABLE_NAME, null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            return ColorAndFontOptions.FONT_CONFIGURABLE_NAME;
        }

        public DisplayPriority getPriority() {
            return DisplayPriority.FONT_SETTINGS;
        }
    }
}

