/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.util.Condition;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeColorDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    @NotNull
    protected final List<OptionsPanelImpl.ColorDescriptionPanel> myDescriptionPanels = new ArrayList<OptionsPanelImpl.ColorDescriptionPanel>();
    @NotNull
    protected final List<Condition<EditorSchemeAttributeDescriptor>> myConditions = new ArrayList<Condition<EditorSchemeAttributeDescriptor>>();
    @NotNull
    private final List<OptionsPanelImpl.ColorDescriptionPanel.Listener> myListeners = new ArrayList<OptionsPanelImpl.ColorDescriptionPanel.Listener>();
    private OptionsPanelImpl.ColorDescriptionPanel myActive;

    public void addDescriptionPanel(@NotNull OptionsPanelImpl.ColorDescriptionPanel descriptionPanel, @NotNull Condition<EditorSchemeAttributeDescriptor> condition) {
        this.myDescriptionPanels.add(descriptionPanel);
        this.myConditions.add(condition);
        for (OptionsPanelImpl.ColorDescriptionPanel.Listener listener2 : this.myListeners) {
            descriptionPanel.addListener(listener2);
        }
        this.updatePreferredSize();
    }

    private void updatePreferredSize() {
        Dimension preferredSize = new Dimension();
        for (OptionsPanelImpl.ColorDescriptionPanel panel2 : this.myDescriptionPanels) {
            Dimension size = panel2.getPanel().getPreferredSize();
            preferredSize.setSize(Math.max(size.getWidth(), preferredSize.getWidth()), Math.max(size.getHeight(), preferredSize.getHeight()));
        }
        this.setPreferredSize(preferredSize);
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void resetDefault() {
        if (this.myActive != null) {
            PaintLocker locker = new PaintLocker(this);
            try {
                this.setPreferredSize(this.getSize());
                this.remove(this.myActive.getPanel());
                this.myActive = null;
            }
            finally {
                locker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        JComponent newPanel;
        JComponent oldPanel = this.myActive == null ? null : this.myActive.getPanel();
        this.myActive = this.getPanelForDescriptor(descriptor);
        JComponent jComponent = newPanel = this.myActive == null ? null : this.myActive.getPanel();
        if (oldPanel != newPanel) {
            PaintLocker locker = new PaintLocker(this);
            try {
                if (oldPanel != null) {
                    this.remove(oldPanel);
                }
                if (newPanel != null) {
                    this.setPreferredSize(null);
                    this.add(newPanel);
                }
            }
            finally {
                locker.release();
            }
        }
        if (this.myActive != null) {
            this.myActive.reset(descriptor);
        }
    }

    @Nullable
    private OptionsPanelImpl.ColorDescriptionPanel getPanelForDescriptor(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        for (int i = this.myConditions.size() - 1; i >= 0; --i) {
            Condition<EditorSchemeAttributeDescriptor> condition = this.myConditions.get(i);
            OptionsPanelImpl.ColorDescriptionPanel panel2 = this.myDescriptionPanels.get(i);
            if (!condition.value((Object)descriptor)) continue;
            return panel2;
        }
        return null;
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor descriptor, EditorColorsScheme scheme2) {
        if (this.myActive != null) {
            this.myActive.apply(descriptor, scheme2);
        }
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        for (OptionsPanelImpl.ColorDescriptionPanel panel2 : this.myDescriptionPanels) {
            panel2.addListener(listener2);
        }
        this.myListeners.add(listener2);
    }

    private static class PaintLocker {
        private final Container myPaintHolder;
        private final boolean myPaintState;

        PaintLocker(@NotNull JComponent component) {
            this.myPaintHolder = component.getParent();
            this.myPaintState = this.myPaintHolder.getIgnoreRepaint();
            this.myPaintHolder.setIgnoreRepaint(true);
        }

        public void release() {
            this.myPaintHolder.validate();
            this.myPaintHolder.setIgnoreRepaint(this.myPaintState);
            this.myPaintHolder.repaint();
        }
    }
}

