/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.fileStatus;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class FileStatusColorDescriptor {
    private final FileStatus myStatus;
    private Color myColor;
    private final Color myDefaultColor;

    public FileStatusColorDescriptor(@NotNull FileStatus fileStatus, Color color, Color defaultColor) {
        this.myStatus = fileStatus;
        this.myColor = color;
        this.myDefaultColor = defaultColor;
    }

    @NotNull
    public FileStatus getStatus() {
        return this.myStatus;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public boolean isDefault() {
        return Comparing.equal((Object)this.myColor, (Object)this.myDefaultColor);
    }

    public void resetToDefault() {
        this.myColor = this.myDefaultColor;
    }

    public Color getDefaultColor() {
        return this.myDefaultColor;
    }
}

