/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.fileStatus;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.fileStatus.FileStatusColorDescriptor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusColorsTableModel
extends AbstractTableModel {
    private final EditorColorsScheme myScheme;
    private final List<FileStatusColorDescriptor> myDescriptors;
    private static final ColumnInfo[] COLUMNS_INFO = new ColumnInfo[]{new ColumnInfo(Boolean.class, "", descriptor -> descriptor.isDefault()), new ColumnInfo(String.class, ApplicationBundle.message((String)"file.status.colors.header.status", (Object[])new Object[0]), descriptor -> descriptor.getStatus().getText())};

    public FileStatusColorsTableModel(@NotNull FileStatus[] fileStatuses, @NotNull EditorColorsScheme scheme2) {
        this.myScheme = scheme2;
        this.myDescriptors = FileStatusColorsTableModel.createDescriptors(fileStatuses, this.myScheme);
    }

    private static List<FileStatusColorDescriptor> createDescriptors(@NotNull FileStatus[] fileStatuses, @NotNull EditorColorsScheme scheme2) {
        EditorColorsScheme baseScheme = scheme2 instanceof AbstractColorsScheme ? ((AbstractColorsScheme)scheme2).getParentScheme() : null;
        ArrayList<FileStatusColorDescriptor> descriptors = new ArrayList<FileStatusColorDescriptor>();
        for (FileStatus fileStatus : fileStatuses) {
            Color color = scheme2.getColor(fileStatus.getColorKey());
            Color originalColor = baseScheme != null ? baseScheme.getColor(fileStatus.getColorKey()) : null;
            descriptors.add(new FileStatusColorDescriptor(fileStatus, color, originalColor));
        }
        Collections.sort(descriptors, Comparator.comparing(d -> d.getStatus().getText()));
        return descriptors;
    }

    @Override
    public int getRowCount() {
        return this.myDescriptors.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS_INFO.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return FileStatusColorsTableModel.COLUMNS_INFO[columnIndex].columnName;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return FileStatusColorsTableModel.COLUMNS_INFO[columnIndex].columnClass;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileStatusColorDescriptor descriptor = this.myDescriptors.get(rowIndex);
        return FileStatusColorsTableModel.COLUMNS_INFO[columnIndex].dataFunction.apply(descriptor);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myDescriptors.get(rowIndex).setColor((Color)aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void resetToDefault(int rowIndex) {
        this.myDescriptors.get(rowIndex).resetToDefault();
        this.fireTableCellUpdated(rowIndex, 1);
    }

    @Nullable
    FileStatusColorDescriptor getDescriptorByName(String statusName) {
        for (FileStatusColorDescriptor descriptor : this.myDescriptors) {
            if (!statusName.equals(descriptor.getStatus().getText())) continue;
            return descriptor;
        }
        return null;
    }

    public boolean isModified() {
        for (FileStatusColorDescriptor descriptor : this.myDescriptors) {
            Color current;
            ColorKey key = descriptor.getStatus().getColorKey();
            Color original = this.myScheme.getColor(key);
            if (Comparing.equal((Object)original, (Object)(current = descriptor.getColor()))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        for (FileStatusColorDescriptor descriptor : this.myDescriptors) {
            descriptor.setColor(this.myScheme.getColor(descriptor.getStatus().getColorKey()));
        }
        this.fireTableDataChanged();
    }

    public void apply() {
        for (FileStatusColorDescriptor descriptor : this.myDescriptors) {
            this.myScheme.setColor(descriptor.getStatus().getColorKey(), descriptor.getColor());
        }
        if (this.myScheme instanceof AbstractColorsScheme) {
            ((AbstractColorsScheme)this.myScheme).setSaveNeeded(true);
        }
        if (EditorColorsManagerImpl.isTempScheme(this.myScheme)) {
            ColorAndFontOptions.writeTempScheme(this.myScheme);
        }
    }

    @Nullable
    public FileStatusColorDescriptor getDescriptorAt(int index) {
        if (index >= 0 && index < this.myDescriptors.size()) {
            return this.myDescriptors.get(index);
        }
        return null;
    }

    public boolean containsCustomSettings() {
        for (FileStatusColorDescriptor descriptor : this.myDescriptors) {
            if (descriptor.isDefault()) continue;
            return true;
        }
        return false;
    }

    private static class ColumnInfo {
        public Class columnClass;
        public String columnName;
        public Function<FileStatusColorDescriptor, Object> dataFunction;

        ColumnInfo(Class columnClass, String columnName, Function<FileStatusColorDescriptor, Object> dataFunction) {
            this.columnClass = columnClass;
            this.columnName = columnName;
            this.dataFunction = dataFunction;
        }
    }
}

