/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineElementData
extends HighlightData {
    private final String myText;
    private final boolean myAddBorder;

    public InlineElementData(int offset, TextAttributesKey attributesKey, String text, ColorKey additionalColorKey) {
        this(offset, attributesKey, text, false, additionalColorKey);
    }

    private InlineElementData(int offset, TextAttributesKey attributesKey, String text, boolean highlighted, ColorKey additionalColorKey) {
        super(offset, offset, attributesKey, additionalColorKey);
        this.myText = text;
        this.myAddBorder = highlighted;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public void addHighlToView(Editor view, EditorColorsScheme scheme2, Map<TextAttributesKey, String> displayText) {
        int offset = this.getStartOffset();
        RendererWrapper renderer2 = new RendererWrapper(new HintRenderer(this.myText){

            @Override
            @Nullable
            protected TextAttributes getTextAttributes(@NotNull Editor editor) {
                return editor.getColorsScheme().getAttributes(InlineElementData.this.getHighlightKey());
            }
        });
        renderer2.drawBorder = this.myAddBorder;
        view.getInlayModel().addInlineElement(offset, false, (EditorCustomElementRenderer)renderer2);
    }

    @Override
    public void addToCollection(@NotNull Collection<? super HighlightData> list2, boolean highlighted) {
        list2.add(new InlineElementData(this.getStartOffset(), this.getHighlightKey(), this.myText, highlighted, this.getAdditionalColorKey()));
    }

    public static class RendererWrapper
    implements EditorCustomElementRenderer {
        private final EditorCustomElementRenderer myDelegate;
        private boolean drawBorder;

        public RendererWrapper(EditorCustomElementRenderer delegate) {
            this.myDelegate = delegate;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            return this.myDelegate.calcWidthInPixels(inlay);
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            TextAttributes attributes;
            this.myDelegate.paint(inlay, g, r, textAttributes);
            if (this.drawBorder && (attributes = inlay.getEditor().getColorsScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES)) != null && attributes.getEffectColor() != null) {
                g.setColor(attributes.getEffectColor());
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }
}

