/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.application.options.colors.pluginExport.ColorSchemePluginTemplate;
import com.intellij.application.options.colors.pluginExport.PluginExportData;
import com.intellij.application.options.colors.pluginExport.PluginInfoDialog;
import com.intellij.application.options.schemes.SerializableSchemeExporter;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSchemePluginExporter
extends ConfigurableSchemeExporter<PluginExportData, EditorColorsScheme> {
    public void exportScheme(@NotNull EditorColorsScheme scheme2, @NotNull OutputStream outputStream, @Nullable PluginExportData exportData) throws Exception {
        if (exportData != null) {
            try (ZipOutputStream zipStream = new ZipOutputStream(outputStream);){
                zipStream.putNextEntry(new ZipEntry("META-INF/plugin.xml"));
                ColorSchemePluginExporter.writePluginXml(scheme2, zipStream, exportData);
                zipStream.putNextEntry(new ZipEntry("colors/" + scheme2.getName() + ".xml"));
                SerializableSchemeExporter.writeToStream((SerializableScheme)scheme2, zipStream);
            }
        }
    }

    public String getExtension() {
        return "jar";
    }

    @Nullable
    public PluginExportData getConfiguration(@NotNull Component parent, @NotNull EditorColorsScheme scheme2) {
        PluginExportData exportData = ColorSchemePluginExporter.getPluginExportData(scheme2);
        EditorColorsScheme schemeToUpdate = ColorSchemePluginExporter.getSchemeToUpdate(scheme2);
        PluginInfoDialog infoDialog = new PluginInfoDialog(parent, exportData);
        if (infoDialog.showAndGet()) {
            infoDialog.apply();
            exportData.saveToProperties(schemeToUpdate.getMetaProperties());
            if (schemeToUpdate instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)schemeToUpdate).setSaveNeeded(true);
            }
            return exportData;
        }
        return null;
    }

    private static void writePluginXml(@NotNull EditorColorsScheme scheme2, @NotNull OutputStream outputStream, @NotNull PluginExportData exportData) throws IOException {
        ColorSchemePluginTemplate template = new ColorSchemePluginTemplate(scheme2, exportData);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write(template.getText());
        writer.flush();
    }

    @NotNull
    private static EditorColorsScheme getSchemeToUpdate(@NotNull EditorColorsScheme scheme2) {
        AbstractColorsScheme original;
        if (scheme2 instanceof AbstractColorsScheme && (original = ((AbstractColorsScheme)scheme2).getOriginal()) != null) {
            return original;
        }
        return scheme2;
    }

    @NotNull
    private static PluginExportData getPluginExportData(@NotNull EditorColorsScheme scheme2) {
        AbstractColorsScheme original;
        PluginExportData data = new PluginExportData(scheme2.getMetaProperties());
        if (data.isEmpty() && scheme2 instanceof AbstractColorsScheme && !(scheme2 instanceof ReadOnlyColorsScheme) && (original = ((AbstractColorsScheme)scheme2).getOriginal()) != null) {
            return ColorSchemePluginExporter.getPluginExportData(original);
        }
        return data;
    }
}

