/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHintsOptionsTopHitProvider
extends OptionsTopHitProvider {
    private final Collection<OptionDescription> myOptions = Collections.singleton(new BooleanOptionDescription("Appearance: " + EditorHintsOptionsTopHitProvider.messageApp("checkbox.show.parameter.name.hints"), "editor.preferences.appearance"){

        public boolean isOptionEnabled() {
            return EditorSettingsExternalizable.getInstance().isShowParameterNameHints();
        }

        public void setOptionState(boolean enabled) {
            EditorSettingsExternalizable.getInstance().setShowParameterNameHints(enabled);
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }
    });

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project) {
        return this.myOptions;
    }

    @Override
    public String getId() {
        return "editor";
    }
}

