/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.fonts.AppEditorFontPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LazyInstance;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEditorFontConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "editor.preferences.fonts.default";
    private final LazyInstance<AppEditorFontPanel> myFontPanelInstance = new LazyInstance<AppEditorFontPanel>(){

        protected Class<AppEditorFontPanel> getInstanceClass() throws ClassNotFoundException {
            return AppEditorFontPanel.class;
        }
    };

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getFontPanel().getComponent();
    }

    public boolean isModified() {
        this.getFontPanel().getOptionsPanel().updateWarning();
        return !AppEditorFontConfigurable.getStoredPreferences().equals(this.getUIFontPreferences());
    }

    public void apply() throws ConfigurationException {
        FontPreferences fontPreferences = this.getUIFontPreferences();
        fontPreferences.copyTo(AppEditorFontConfigurable.getStoredPreferences());
        EditorFontCache.getInstance().reset();
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        EditorOptionsPanel.reinitAllEditors();
    }

    @NotNull
    private FontPreferences getUIFontPreferences() {
        return this.getFontPanel().getOptionsPanel().getFontPreferences();
    }

    public void reset() {
        AppEditorFontConfigurable.getStoredPreferences().copyTo(this.getUIFontPreferences());
        this.getFontPanel().getOptionsPanel().updateOnChangedFont();
    }

    @NotNull
    private static FontPreferences getStoredPreferences() {
        return AppEditorFontOptions.getInstance().getFontPreferences();
    }

    @NotNull
    private AppEditorFontPanel getFontPanel() {
        return (AppEditorFontPanel)this.myFontPanelInstance.getValue();
    }

    @Nls
    public String getDisplayName() {
        return "Font";
    }

    public void disposeUIResources() {
        if (this.myFontPanelInstance.isComputed()) {
            Disposer.dispose((Disposable)this.getFontPanel());
        }
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.colors";
    }
}

