/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.editor.fonts.AppEditorFontOptionsPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class AppEditorFontPanel
implements Disposable {
    @NotNull
    private final AppEditorFontOptionsPanel myOptionsPanel;
    @NotNull
    private final FontEditorPreview myPreview;
    @NotNull
    private final EditorColorsScheme myPreviewScheme;
    @NotNull
    private final JPanel myTopPanel = new JPanel(new BorderLayout(0, 10));

    public AppEditorFontPanel() {
        this.myPreviewScheme = AppEditorFontPanel.createPreviewScheme();
        this.myOptionsPanel = new AppEditorFontOptionsPanel(this.myPreviewScheme);
        this.myTopPanel.add((Component)this.myOptionsPanel, "North");
        this.myPreview = new FontEditorPreview(() -> this.myPreviewScheme, true);
        this.myTopPanel.add(this.myPreview.getPanel(), "Center");
        this.myOptionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                AppEditorFontPanel.this.updatePreview();
            }
        });
    }

    public void updatePreview() {
        if (this.myPreviewScheme instanceof EditorFontCache) {
            ((EditorFontCache)this.myPreviewScheme).reset();
        }
        this.myPreview.updateView();
    }

    public void dispose() {
        this.myPreview.disposeUIResources();
    }

    @NotNull
    private static EditorColorsScheme createPreviewScheme() {
        EditorColorsScheme scheme2 = (EditorColorsScheme)EditorColorsManager.getInstance().getSchemeForCurrentUITheme().clone();
        scheme2.setFontPreferences((FontPreferences)new FontPreferencesImpl());
        return scheme2;
    }

    @NotNull
    public JPanel getComponent() {
        return this.myTopPanel;
    }

    @NotNull
    public AppEditorFontOptionsPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }
}

