/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class PathMacroEditor
extends DialogWrapper {
    private JTextField myNameField;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myValueField;
    private final Validator myValidator;

    public PathMacroEditor(String title, String macroName, String value, Validator validator) {
        super(true);
        this.$$$setupUI$$$();
        this.setTitle(title);
        this.myValidator = validator;
        this.myNameField.setText(macroName);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                PathMacroEditor.this.updateControls();
            }
        };
        this.myNameField.getDocument().addDocumentListener((DocumentListener)documentListener);
        this.myValueField.setText(value);
        this.myValueField.addBrowseFolderListener(null, null, null, new FileChooserDescriptor(false, true, true, false, true, false), (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                return component.getText();
            }

            public void setText(JTextField component, @NotNull String text) {
                int len = text.length();
                if (len > 0 && text.charAt(len - 1) == File.separatorChar) {
                    text = text.substring(0, len - 1);
                }
                component.setText(text);
            }
        });
        this.myValueField.getTextField().getDocument().addDocumentListener((DocumentListener)documentListener);
        this.init();
        this.updateControls();
    }

    public void setMacroNameEditable(boolean isEditable) {
        this.myNameField.setEditable(isEditable);
    }

    private void updateControls() {
        boolean isNameOK = this.myValidator.checkName(this.myNameField.getText());
        this.getOKAction().setEnabled(isNameOK);
        if (isNameOK) {
            String text = this.myValueField.getText().trim();
            this.getOKAction().setEnabled(text.length() > 0 && !"/".equals(text.trim()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected String getHelpId() {
        return "preferences.pathVariables";
    }

    protected void doOKAction() {
        if (!this.myValidator.isOK(this.getName(), this.getValue())) {
            return;
        }
        super.doOKAction();
    }

    public String getName() {
        return this.myNameField.getText().trim();
    }

    public String getValue() {
        String path = this.myValueField.getText().trim();
        File file2 = new File(path);
        if (file2.isAbsolute()) {
            try {
                return file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path;
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myValueField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.path.macro.name"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.path.macro.value"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Validator {
        public boolean checkName(String var1);

        public boolean isOK(String var1, String var2);
    }
}

