/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.CommonBundle;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemeActions<T extends Scheme> {
    private final Collection<String> mySchemeImportersNames;
    private final Collection<String> mySchemeExporterNames;
    @NotNull
    protected final AbstractSchemesPanel<T, ?> mySchemesPanel;

    protected AbstractSchemeActions(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        this.mySchemesPanel = schemesPanel;
        this.mySchemeImportersNames = this.getSchemeImportersNames();
        this.mySchemeExporterNames = this.getSchemeExporterNames();
    }

    @NotNull
    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (SchemeImporterEP<T> importerEP : SchemeImporterEP.getExtensions(this.getSchemeType())) {
            importersNames.add(importerEP.name);
        }
        return importersNames;
    }

    @NotNull
    private Collection<String> getSchemeExporterNames() {
        ArrayList<String> exporterNames = new ArrayList<String>();
        for (SchemeExporterEP<T> exporterEP : SchemeExporterEP.getExtensions(this.getSchemeType())) {
            exporterNames.add(exporterEP.name);
        }
        return exporterNames;
    }

    @NotNull
    public final Collection<AnAction> getActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            actions.add((AnAction)new CopyToProjectAction());
            actions.add((AnAction)new CopyToIDEAction());
            actions.add((AnAction)new Separator());
        }
        actions.add((AnAction)new CopyAction());
        actions.add((AnAction)new RenameAction());
        this.addAdditionalActions(actions);
        actions.add((AnAction)new ResetAction());
        actions.add((AnAction)new DeleteAction());
        if (!this.mySchemeExporterNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.export", (Object[])new Object[0]), this.mySchemeExporterNames, (x$0, x$1) -> new ExportAction((String)x$0, (String)x$1)));
        }
        actions.add((AnAction)new Separator());
        if (!this.mySchemeImportersNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.import", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), this.mySchemeImportersNames, (x$0, x$1) -> new ImportAction((String)x$0, (String)x$1)));
        }
        return actions;
    }

    protected void addAdditionalActions(@NotNull List<? super AnAction> defaultActions) {
    }

    @NotNull
    private static AnAction createImportExportAction(@NotNull String groupName, @NotNull Collection<String> actionNames, final @NotNull BiFunction<? super String, ? super String, ? extends AnAction> createActionByName) {
        if (actionNames.size() == 1) {
            return createActionByName.apply((String)ContainerUtil.getFirstItem(actionNames), groupName + "...");
        }
        return new ImportExportActionGroup(groupName, actionNames){

            @Override
            @NotNull
            protected AnAction createAction(@NotNull String actionName) {
                return (AnAction)createActionByName.apply(actionName, actionName);
            }
        };
    }

    protected void importScheme(@NotNull String importerName) {
    }

    protected abstract void resetScheme(@NotNull T var1);

    protected abstract void duplicateScheme(@NotNull T var1, @NotNull String var2);

    private void deleteScheme(@NotNull T scheme2) {
        if (Messages.showOkCancelDialog((String)("Do you want to delete \"" + scheme2.getName() + "\" " + StringUtil.toLowerCase((String)this.mySchemesPanel.getSchemeTypeName()) + "?"), (String)("Delete " + this.mySchemesPanel.getSchemeTypeName()), (String)"Delete", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
            this.mySchemesPanel.getModel().removeScheme(scheme2);
        }
    }

    protected void exportScheme(@NotNull T scheme2, @NotNull String exporterName) {
        SchemeExporter<T> exporter = SchemeExporterEP.getExporter(exporterName, this.getSchemeType());
        if (exporter != null) {
            Object config2 = null;
            if (exporter instanceof ConfigurableSchemeExporter && (config2 = ((ConfigurableSchemeExporter)exporter).getConfiguration(this.mySchemesPanel, scheme2)) == null) {
                return;
            }
            String ext = exporter.getExtension();
            FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.title", (Object[])new Object[0]), ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.message", (Object[])new Object[0]), new String[]{ext}), this.getSchemesPanel());
            VirtualFileWrapper target2 = saver.save(null, SchemeManager.getDisplayName(scheme2) + "." + ext);
            if (target2 != null) {
                MessageType messageType;
                String message;
                VirtualFile targetFile = target2.getVirtualFile(true);
                if (targetFile != null) {
                    try {
                        Object finalConfig = config2;
                        WriteAction.run(() -> {
                            try (OutputStream outputStream = targetFile.getOutputStream((Object)this);){
                                if (exporter instanceof ConfigurableSchemeExporter) {
                                    ((ConfigurableSchemeExporter)exporter).exportScheme(scheme2, outputStream, finalConfig);
                                }
                                exporter.exportScheme(scheme2, outputStream);
                            }
                        });
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.scheme.exported.message", (Object[])new Object[]{scheme2.getName(), this.getSchemesPanel().getSchemeTypeName(), targetFile.getPresentableUrl()});
                        messageType = MessageType.INFO;
                    }
                    catch (Exception e) {
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e.getMessage()});
                        messageType = MessageType.ERROR;
                    }
                } else {
                    message = ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
                    messageType = MessageType.ERROR;
                }
                this.getSchemesPanel().showStatus(message, messageType);
            }
        }
    }

    protected abstract void onSchemeChanged(@Nullable T var1);

    protected abstract void renameScheme(@NotNull T var1, @NotNull String var2);

    protected void copyToProject(@NotNull T scheme2) {
    }

    protected void copyToIDE(@NotNull T scheme2) {
    }

    @NotNull
    protected SchemesModel<T> getModel() {
        return this.mySchemesPanel.getModel();
    }

    @Nullable
    protected final T getCurrentScheme() {
        return this.mySchemesPanel.getSelectedScheme();
    }

    @NotNull
    protected abstract Class<T> getSchemeType();

    @NotNull
    public final AbstractSchemesPanel<T, ?> getSchemesPanel() {
        return this.mySchemesPanel;
    }

    private class ExportAction
    extends DumbAwareAction {
        private final String myExporterName;

        ExportAction(@NotNull String exporterName, String exporterText) {
            super(exporterText);
            this.myExporterName = exporterName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.exportScheme(currentScheme, this.myExporterName);
            }
        }
    }

    private class ImportAction
    extends DumbAwareAction {
        private final String myImporterName;

        ImportAction(@NotNull String importerName, String importerText) {
            super(importerText);
            this.myImporterName = importerName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
            AbstractSchemeActions.this.importScheme(this.myImporterName);
        }
    }

    private static abstract class ImportExportActionGroup
    extends ActionGroup {
        private final Collection<String> myActionNames;

        ImportExportActionGroup(@NotNull String groupName, @NotNull Collection<String> actionNames) {
            super(groupName, true);
            this.myActionNames = actionNames;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<AnAction> namedActions = new ArrayList<AnAction>();
            for (String actionName : this.myActionNames) {
                namedActions.add(this.createAction(actionName));
            }
            return namedActions.toArray(AnAction.EMPTY_ARRAY);
        }

        @NotNull
        protected abstract AnAction createAction(@NotNull String var1);
    }

    private class DeleteAction
    extends DumbAwareAction {
        DeleteAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.delete", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.deleteScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isEnabled;
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            boolean bl = isEnabled = scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDeleteScheme(scheme2);
            if (AbstractSchemeActions.this.mySchemesPanel.hideDeleteActionIfUnavailable()) {
                p.setEnabledAndVisible(isEnabled);
            } else {
                p.setEnabled(isEnabled);
            }
        }
    }

    private class RenameAction
    extends DumbAwareAction {
        RenameAction() {
            super("Rename...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AbstractSchemeActions.this.mySchemesPanel.editCurrentSchemeName((currentScheme, newName) -> AbstractSchemeActions.this.renameScheme(currentScheme, (String)newName));
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canRenameScheme(scheme2));
        }
    }

    private class CopyAction
    extends DumbAwareAction {
        CopyAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.editNewSchemeName(SchemeManager.getDisplayName(currentScheme), AbstractSchemeActions.this.mySchemesPanel.supportsProjectSchemes() && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme), newName -> AbstractSchemeActions.this.duplicateScheme(currentScheme, (String)newName));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDuplicateScheme(scheme2));
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        ResetAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.reset", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.resetScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme2 = AbstractSchemeActions.this.getCurrentScheme();
            if (scheme2 != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canResetScheme(scheme2)) {
                p.setVisible(true);
                p.setEnabled(AbstractSchemeActions.this.mySchemesPanel.getModel().differsFromDefault(scheme2));
            } else {
                p.setEnabledAndVisible(false);
            }
        }
    }

    private class CopyToIDEAction
    extends DumbAwareAction {
        CopyToIDEAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.ide", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToIDE(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }

    private class CopyToProjectAction
    extends DumbAwareAction {
        CopyToProjectAction() {
            super(ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToProject(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }
}

