/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import java.util.function.Predicate;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesCombo<T extends Scheme>
extends ComboBox<MySchemeListItem<T>> {
    public static final String PROJECT_LEVEL = "Project";
    public static final String IDE_LEVEL = "IDE";

    public SchemesCombo() {
        super(new MyComboBoxModel());
        this.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
    }

    public void resetSchemes(@NotNull Collection<? extends T> schemes) {
        MyComboBoxModel model = (MyComboBoxModel)this.getModel();
        model.removeAllElements();
        if (this.supportsProjectSchemes()) {
            model.addElement(new MySeparatorItem(PROJECT_LEVEL));
            this.addItems(schemes, scheme2 -> this.isProjectScheme(scheme2));
            model.addElement(new MySeparatorItem(IDE_LEVEL));
            this.addItems(schemes, scheme2 -> !this.isProjectScheme(scheme2));
        } else {
            this.addItems(schemes, scheme2 -> true);
        }
    }

    public void selectScheme(@Nullable T scheme2) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (((MySchemeListItem)this.getItemAt(i)).getScheme() != scheme2) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    @Nullable
    public T getSelectedScheme() {
        Object item = this.getSelectedItem();
        return item != null ? (T)((MySchemeListItem)item).getScheme() : null;
    }

    @Nullable
    public MySchemeListItem<T> getSelectedItem() {
        int i = this.getSelectedIndex();
        return i >= 0 ? (MySchemeListItem)this.getItemAt(i) : null;
    }

    protected abstract boolean supportsProjectSchemes();

    protected boolean isProjectScheme(@NotNull T scheme2) {
        throw new UnsupportedOperationException();
    }

    protected int getIndent(@NotNull T scheme2) {
        return 0;
    }

    @NotNull
    protected abstract SimpleTextAttributes getSchemeAttributes(T var1);

    private void addItems(@NotNull Collection<? extends T> schemes, Predicate<? super T> filter) {
        for (Scheme scheme2 : schemes) {
            if (!filter.test(scheme2)) continue;
            ((MyComboBoxModel)this.getModel()).addElement(new MySchemeListItem<Scheme>(scheme2));
        }
    }

    private static class MyTitledSeparator
    extends JPanel {
        MyTitledSeparator(@NotNull String titleText) {
            this.setLayout(new BoxLayout(this, 0));
            JLabel label2 = new JLabel(titleText);
            int verticalSeparatorOffset = label2.getPreferredSize().height / 2;
            this.setBackground((Color)JBColor.WHITE);
            this.add(MyTitledSeparator.createSeparator(verticalSeparatorOffset));
            label2.setHorizontalAlignment(0);
            this.add(label2);
            label2.setBackground((Color)JBColor.WHITE);
            label2.setForeground((Color)JBColor.GRAY);
            label2.setFont(UIUtil.getTitledBorderFont());
            this.add(MyTitledSeparator.createSeparator(verticalSeparatorOffset));
        }

        private static JComponent createSeparator(int verticalOffset) {
            JPanel separatorPanel = new JPanel();
            separatorPanel.setBackground((Color)JBColor.WHITE);
            separatorPanel.setLayout(new BoxLayout(separatorPanel, 1));
            separatorPanel.add(Box.createVerticalStrut(verticalOffset));
            JSeparator separator = new JSeparator();
            separatorPanel.add(separator);
            return separatorPanel;
        }
    }

    private class MySeparatorItem
    extends MySchemeListItem<T> {
        private final String myTitle;

        MySeparatorItem(String title) {
            super(null);
            this.myTitle = title;
        }

        @Override
        public boolean isSeparator() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText() {
            return this.myTitle;
        }
    }

    private static class MyComboBoxModel<T extends Scheme>
    extends DefaultComboBoxModel<MySchemeListItem<T>> {
        private MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof MySchemeListItem && ((MySchemeListItem)anObject).isSeparator()) {
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<MySchemeListItem<T>> {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends MySchemeListItem<T>> list2, MySchemeListItem<T> value, int index, boolean selected, boolean hasFocus) {
            Component c;
            if (value != null && value.isSeparator()) {
                c = new MyTitledSeparator("Stored in " + value.getPresentableText());
            } else {
                c = super.getListCellRendererComponent(list2, value, index, selected, hasFocus);
                if (!selected) {
                    c.setBackground((Color)JBColor.WHITE);
                }
            }
            return c;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MySchemeListItem<T>> list2, MySchemeListItem<T> value, int index, boolean selected, boolean hasFocus) {
            Object scheme2 = value.getScheme();
            if (scheme2 != null) {
                this.append(value.getPresentableText(), SchemesCombo.this.getSchemeAttributes(scheme2));
                if (SchemesCombo.this.supportsProjectSchemes() && index == -1) {
                    this.append("  " + (SchemesCombo.this.isProjectScheme(scheme2) ? SchemesCombo.PROJECT_LEVEL : SchemesCombo.IDE_LEVEL), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
            int indent = index < 0 || scheme2 == null ? 0 : SchemesCombo.this.getIndent(scheme2);
            this.setIpad((Insets)JBUI.insetsLeft((int)(indent > 0 ? indent * 10 : 0)));
        }
    }

    static class MySchemeListItem<T extends Scheme> {
        @Nullable
        private final T myScheme;

        MySchemeListItem(@Nullable T scheme2) {
            this.myScheme = scheme2;
        }

        @Nullable
        public String getSchemeName() {
            return this.myScheme != null ? this.myScheme.getName() : null;
        }

        @Nullable
        public T getScheme() {
            return this.myScheme;
        }

        @NotNull
        public String getPresentableText() {
            return this.myScheme != null ? SchemeManager.getDisplayName(this.myScheme) : "";
        }

        public boolean isSeparator() {
            return false;
        }
    }
}

