/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;

public class SerializableSchemeExporter
extends SchemeExporter<Scheme> {
    public void exportScheme(@NotNull Scheme scheme2, @NotNull OutputStream outputStream) throws Exception {
        assert (scheme2 instanceof SerializableScheme);
        SerializableSchemeExporter.writeToStream((SerializableScheme)scheme2, outputStream);
    }

    public static void writeToStream(@NotNull SerializableScheme scheme2, @NotNull OutputStream outputStream) throws IOException {
        SerializableSchemeExporter.writeToStream(outputStream, scheme2.writeScheme());
    }

    public String getExtension() {
        return "xml";
    }

    private static void writeToStream(@NotNull OutputStream outputStream, @NotNull Element element) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        Format format = Format.getPrettyFormat();
        format.setLineSeparator("\n");
        new XMLOutputter(format).output(element, (Writer)writer);
    }
}

