/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Locale;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinTrayUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.SwitchBootJdkAction");
    @NotNull
    private static final String productJdkConfigFileName = BinTrayUtil.getExecutable() + (SystemInfo.isWindows ? (SystemInfo.is64Bit ? "64.exe.jdk" : ".exe.jdk") : ".jdk");
    @Nullable
    private static final String pathsSelector = PathManager.getPathsSelector();
    @NotNull
    private static final File productJdkConfigDir = new File(pathsSelector != null ? PathManager.getDefaultConfigPathFor((String)pathsSelector) : PathManager.getConfigPath());
    @NotNull
    private static final File productJdkConfigFile = new File(productJdkConfigDir, productJdkConfigFileName);

    private static String getExecutable() {
        String executable = System.getProperty("idea.executable");
        return executable != null ? executable : ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
    }

    @NotNull
    public static File getJdkConfigFilePath() {
        if (!productJdkConfigDir.exists()) {
            try {
                if (!productJdkConfigDir.mkdirs()) {
                    LOG.error("Could not create " + productJdkConfigDir + " productJdkConfigDir");
                    return null;
                }
                if (!productJdkConfigFile.exists() && !productJdkConfigFile.createNewFile()) {
                    LOG.error("Could not create " + productJdkConfigFileName + " productJdkConfigFile");
                }
            }
            catch (IOException var1) {
                LOG.error((Throwable)var1);
            }
        }
        return productJdkConfigFile;
    }

    @NotNull
    public static String archveToDirectoryName(String archiveFileName) {
        return archiveFileName.substring(0, archiveFileName.lastIndexOf(".tar.gz"));
    }

    @NotNull
    public static File downloadPath() {
        return new File(PathManager.getPluginTempPath(), "jdk_archives");
    }

    public static void updateJdkConfigFileAndRestart(File directoryToExtractFile) {
        File jdkConfigFilePath = BinTrayUtil.getJdkConfigFilePath();
        if (jdkConfigFilePath != null) {
            try (FileWriter fooWriter = new FileWriter(jdkConfigFilePath, false);){
                File jdkPath = SystemInfo.isMac ? new File(directoryToExtractFile, "jdk") : directoryToExtractFile;
                String jdk = jdkPath.getPath();
                fooWriter.write(jdk);
            }
            catch (IOException var17) {
                var17.printStackTrace();
            }
            ApplicationManagerEx.getApplicationEx().restart();
        }
    }

    public static File getJdkStoragePathFile() {
        return new File(PathManager.getConfigPath() + File.separator + "jdks" + File.separator);
    }

    public static boolean isInstalled(String selectedItem) {
        File jdkBundleDirFile = new File(BinTrayUtil.getJdkStoragePathFile(), BinTrayUtil.archveToDirectoryName(selectedItem));
        File bundlePathFromItem = SystemInfo.isMac ? new File(jdkBundleDirFile, "jdk") : jdkBundleDirFile;
        return bundlePathFromItem.exists() && BinTrayUtil.isActiveBundle(selectedItem);
    }

    public static boolean isActiveBundle(String selectedItem) {
        File bundlePathFromItem;
        File jdkConfigFilePath = BinTrayUtil.getJdkConfigFilePath();
        File jdkBundleDirFile = new File(BinTrayUtil.getJdkStoragePathFile(), BinTrayUtil.archveToDirectoryName(selectedItem));
        File file2 = bundlePathFromItem = SystemInfo.isMac ? new File(jdkBundleDirFile, "jdk") : jdkBundleDirFile;
        if (jdkConfigFilePath != null && jdkConfigFilePath.exists()) {
            try {
                boolean var6;
                try (Stream<String> lines2 = Files.lines(jdkConfigFilePath.toPath(), Charset.defaultCharset());){
                    var6 = lines2 != null && lines2.anyMatch(pathToBundle -> FileUtil.filesEqual((File)bundlePathFromItem, (File)new File((String)pathToBundle)));
                }
                return var6;
            }
            catch (IOException ioe) {
                LOG.warn((Throwable)ioe);
            }
        }
        return false;
    }
}

