/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.MultipleBuildsView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AbstractViewManager
implements ViewManager,
BuildProgressListener,
Disposable {
    private static final Key<Boolean> PINNED_EXTRACTED_CONTENT = new Key("PINNED_EXTRACTED_CONTENT");
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicClearableLazyValue<MultipleBuildsView> myBuildsViewValue;
    private final Set<MultipleBuildsView> myPinnedViews;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);

    public AbstractViewManager(Project project, BuildContentManager buildContentManager) {
        this.myProject = project;
        this.myBuildContentManager = buildContentManager;
        this.myBuildsViewValue = new AtomicClearableLazyValue<MultipleBuildsView>(){

            @NotNull
            protected MultipleBuildsView compute() {
                MultipleBuildsView buildsView = new MultipleBuildsView(AbstractViewManager.this.myProject, AbstractViewManager.this.myBuildContentManager, AbstractViewManager.this);
                Disposer.register((Disposable)AbstractViewManager.this, (Disposable)buildsView);
                return buildsView;
            }
        };
        this.myPinnedViews = ContainerUtil.newConcurrentSet();
    }

    public boolean isConsoleEnabledByDefault() {
        return false;
    }

    public boolean isBuildContentView() {
        return true;
    }

    @NotNull
    protected abstract String getViewName();

    protected Map<BuildInfo, BuildView> getBuildsMap() {
        return ((MultipleBuildsView)this.myBuildsViewValue.getValue()).getBuildsMap();
    }

    public void onEvent(@NotNull BuildEvent event) {
        MultipleBuildsView buildsView;
        if (this.isDisposed.get()) {
            return;
        }
        if (event instanceof StartBuildEvent) {
            this.configurePinnedContent();
            buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        } else {
            buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
            if (!buildsView.shouldConsume(event)) {
                buildsView = this.myPinnedViews.stream().filter(pinnedView -> pinnedView.shouldConsume(event)).findFirst().orElse(null);
            }
        }
        if (buildsView != null) {
            buildsView.onEvent(event);
        }
    }

    void configureToolbar(DefaultActionGroup toolbarActions, MultipleBuildsView buildsView, BuildView view) {
        toolbarActions.removeAll();
        toolbarActions.addAll(view.createConsoleActions());
        toolbarActions.add((AnAction)new PinBuildViewAction(buildsView));
    }

    @Nullable
    protected Icon getContentIcon() {
        return null;
    }

    protected void onBuildStart(BuildDescriptor buildDescriptor) {
    }

    protected void onBuildFinish(BuildDescriptor buildDescriptor) {
        BuildInfo buildInfo = (BuildInfo)buildDescriptor;
        if (buildInfo.result instanceof FailureResult) {
            boolean activate = buildInfo.activateToolWindowWhenFailed;
            this.myBuildContentManager.setSelectedContent(buildInfo.content, activate, activate, activate, null);
            List failures = ((FailureResult)buildInfo.result).getFailures();
            if (failures.isEmpty()) {
                return;
            }
            Failure failure = (Failure)failures.get(0);
            Notification notification = failure.getNotification();
            if (notification != null) {
                String title = notification.getTitle();
                String content = notification.getContent();
                SystemNotifications.getInstance().notify(ToolWindowId.BUILD, title, content);
            }
        }
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.myPinnedViews.clear();
        this.myBuildsViewValue.drop();
    }

    void onBuildsViewRemove(@NotNull MultipleBuildsView buildsView) {
        if (this.isDisposed.get()) {
            return;
        }
        if (this.myBuildsViewValue.getValue() == buildsView) {
            this.myBuildsViewValue.drop();
        } else {
            this.myPinnedViews.remove(buildsView);
        }
    }

    private void configurePinnedContent() {
        MultipleBuildsView buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        Content content = buildsView.getContent();
        if (content != null && content.isPinned()) {
            String tabName = this.getPinnedTabName(buildsView);
            UIUtil.invokeLaterIfNeeded(() -> {
                content.setPinnable(false);
                if (content.getIcon() == null) {
                    content.setIcon(EmptyIcon.ICON_8);
                }
                content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                ((BuildContentManagerImpl)this.myBuildContentManager).updateTabDisplayName(content, tabName);
            });
            this.myPinnedViews.add(buildsView);
            this.myBuildsViewValue.drop();
            content.putUserData(PINNED_EXTRACTED_CONTENT, (Object)Boolean.TRUE);
        }
    }

    private String getPinnedTabName(MultipleBuildsView buildsView) {
        Map<BuildInfo, BuildView> buildsMap = buildsView.getBuildsMap();
        BuildInfo buildInfo = buildsMap.keySet().stream().reduce((b1, b2) -> b1.getStartTime() <= b2.getStartTime() ? b1 : b2).orElse(null);
        if (buildInfo != null) {
            String title = buildInfo.getTitle();
            String viewName = this.getViewName().split(" ")[0];
            String tabName = viewName + ": " + StringUtil.trimStart((String)title, (String)viewName);
            if (buildsMap.size() > 1) {
                tabName = tabName + String.format(" and %d more", buildsMap.size() - 1);
            }
            return tabName;
        }
        return this.getViewName();
    }

    private static class PinBuildViewAction
    extends DumbAwareAction
    implements Toggleable {
        private final Content myContent;

        PinBuildViewAction(MultipleBuildsView buildsView) {
            this.myContent = buildsView.getContent();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean selected;
            boolean bl = selected = !this.myContent.isPinned();
            if (selected) {
                this.myContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            }
            this.myContent.setPinned(selected);
            e.getPresentation().putClientProperty("selected", (Object)selected);
        }

        public void update(@NotNull AnActionEvent e) {
            if (!this.myContent.isValid()) {
                return;
            }
            Boolean isPinnedAndExtracted = (Boolean)this.myContent.getUserData(PINNED_EXTRACTED_CONTENT);
            if (isPinnedAndExtracted == Boolean.TRUE) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            boolean isActiveTab = this.myContent.getManager().getSelectedContent() == this.myContent;
            boolean selected = this.myContent.isPinned();
            e.getPresentation().setIcon(AllIcons.General.Pin_tab);
            e.getPresentation().putClientProperty("selected", (Object)selected);
            String text = !isActiveTab ? (selected ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (selected ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
            e.getPresentation().setText(text);
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    static class BuildInfo
    extends DefaultBuildDescriptor {
        String message;
        String statusMessage;
        long endTime = -1L;
        EventResult result;
        Content content;
        boolean activateToolWindowWhenAdded;
        boolean activateToolWindowWhenFailed = true;

        BuildInfo(@NotNull Object id, @NotNull String title, @NotNull String workingDir, long startTime) {
            super(id, title, workingDir, startTime);
        }

        public Icon getIcon() {
            return ExecutionNode.getEventResultIcon(this.result);
        }

        public boolean isRunning() {
            return this.endTime == -1L;
        }
    }
}

