/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleView;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class BuildTextConsoleView
extends ConsoleViewImpl
implements BuildConsoleView,
AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

    public BuildTextConsoleView(Project project) {
        this(project, false);
    }

    public BuildTextConsoleView(@NotNull Project project, boolean viewer) {
        super(project, viewer);
    }

    public void onEvent(@NotNull BuildEvent event) {
        Key outputType = event instanceof OutputBuildEvent && !((OutputBuildEvent)event).isStdOut() ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        this.myAnsiEscapeDecoder.escapeText(event.getMessage(), outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        this.print(text, ConsoleViewContentType.getConsoleViewType((Key)attributes));
    }
}

