/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.CompositeView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BuildView
extends CompositeView<ExecutionConsole>
implements BuildProgressListener,
ConsoleView,
DataProvider {
    public static final String CONSOLE_VIEW_NAME = "consoleView";
    private final AtomicReference<StartBuildEvent> myStartBuildEventRef = new AtomicReference();
    private final BuildDescriptor myBuildDescriptor;
    private final Project myProject;
    private final AtomicBoolean isBuildStartEventProcessed = new AtomicBoolean();
    private final List<BuildEvent> myAfterStartEvents = ContainerUtil.createConcurrentList();
    private final ViewManager myViewManager;

    public BuildView(Project project, BuildDescriptor buildDescriptor, String selectionStateKey, ViewManager viewManager) {
        this(project, null, buildDescriptor, selectionStateKey, viewManager);
    }

    public BuildView(Project project, @Nullable ExecutionConsole executionConsole, BuildDescriptor buildDescriptor, String selectionStateKey, ViewManager viewManager) {
        super(selectionStateKey);
        this.myProject = project;
        this.myBuildDescriptor = buildDescriptor;
        this.myViewManager = viewManager;
        if (executionConsole != null) {
            this.addView(executionConsole, CONSOLE_VIEW_NAME, viewManager.isConsoleEnabledByDefault());
        }
    }

    public void onEvent(@NotNull BuildEvent event) {
        if (event instanceof StartBuildEvent) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                this.onStartBuild((StartBuildEvent)event);
                for (BuildEvent buildEvent : this.myAfterStartEvents) {
                    this.processEvent(buildEvent);
                }
                this.myAfterStartEvents.clear();
                this.isBuildStartEventProcessed.set(true);
            });
            return;
        }
        if (!this.isBuildStartEventProcessed.get()) {
            this.myAfterStartEvents.add(event);
        } else {
            this.processEvent(event);
        }
    }

    private void processEvent(BuildEvent event) {
        if (event instanceof OutputBuildEvent) {
            ExecutionConsole consoleView = this.getConsoleView();
            if (consoleView instanceof BuildProgressListener) {
                ((BuildProgressListener)consoleView).onEvent(event);
            }
        } else {
            String eventViewName = BuildTreeConsoleView.class.getName();
            BuildTreeConsoleView eventView = this.getView(eventViewName, BuildTreeConsoleView.class);
            if (eventView != null) {
                EdtExecutorService.getInstance().execute(() -> eventView.onEvent(event));
            }
        }
    }

    private void onStartBuild(StartBuildEvent startBuildEvent) {
        Object executionConsoleView;
        this.myStartBuildEventRef.set(startBuildEvent);
        String eventViewName = BuildTreeConsoleView.class.getName();
        BuildTreeConsoleView eventView = this.getView(eventViewName, BuildTreeConsoleView.class);
        if (eventView == null) {
            eventView = new BuildTreeConsoleView(this.myProject, this.myBuildDescriptor);
            this.addView(eventView, eventViewName, !this.myViewManager.isConsoleEnabledByDefault());
        }
        if ((executionConsoleView = this.getConsoleView()) == null) {
            Supplier descriptorSupplier = startBuildEvent.getContentDescriptorSupplier();
            Filter[] runContentDescriptor = descriptorSupplier != null ? (Filter[])descriptorSupplier.get() : null;
            executionConsoleView = runContentDescriptor != null && runContentDescriptor.getExecutionConsole() != null && runContentDescriptor.getExecutionConsole() != this ? runContentDescriptor.getExecutionConsole() : new BuildTextConsoleView(this.myProject);
            this.addView(executionConsoleView, CONSOLE_VIEW_NAME, this.myViewManager.isConsoleEnabledByDefault());
            if (runContentDescriptor != null && Disposer.findRegisteredObject((Disposable)runContentDescriptor, (Disposable)this) == null) {
                Disposer.register((Disposable)this, (Disposable)runContentDescriptor);
            }
        }
        BuildProcessHandler processHandler2 = startBuildEvent.getProcessHandler();
        if (executionConsoleView instanceof ConsoleView) {
            for (Filter filter : startBuildEvent.getExecutionFilters()) {
                ((ConsoleView)executionConsoleView).addMessageFilter(filter);
            }
            if (processHandler2 != null) {
                ((ConsoleView)executionConsoleView).attachToProcess((ProcessHandler)processHandler2);
                Consumer attachedConsoleConsumer = startBuildEvent.getAttachedConsoleConsumer();
                if (attachedConsoleConsumer != null) {
                    attachedConsoleConsumer.consume((Object)((ConsoleView)executionConsoleView));
                }
                if (!processHandler2.isStartNotified()) {
                    processHandler2.startNotify();
                }
            }
        }
        if (processHandler2 != null && !processHandler2.isStartNotified()) {
            processHandler2.startNotify();
        }
        eventView.onEvent((BuildEvent)startBuildEvent);
    }

    private ExecutionConsole getConsoleView() {
        return this.getView(CONSOLE_VIEW_NAME, ExecutionConsole.class);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.print(text, contentType)));
    }

    private void delegateToConsoleView(Consumer<? super ConsoleView> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            viewConsumer.consume((Object)((ConsoleView)console));
        }
    }

    @Nullable
    private <R> R getConsoleViewValue(Function<? super ConsoleView, ? extends R> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            return viewConsumer.apply((ConsoleView)((ConsoleView)console));
        }
        return null;
    }

    public void clear() {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)ConsoleView::clear));
    }

    public void scrollTo(int offset) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.scrollTo(offset)));
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.attachToProcess(processHandler2)));
    }

    public void setOutputPaused(boolean value) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.setOutputPaused(value)));
    }

    public boolean isOutputPaused() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::isOutputPaused);
        return result2 != null && result2 != false;
    }

    public boolean hasDeferredOutput() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::hasDeferredOutput);
        return result2 != null && result2 != false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.performWhenNoDeferredOutput(runnable2)));
    }

    public void setHelpId(@NotNull String helpId) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.setHelpId(helpId)));
    }

    public void addMessageFilter(@NotNull Filter filter) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.addMessageFilter(filter)));
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.printHyperlink(hyperlinkText, info)));
    }

    public int getContentSize() {
        Integer result2 = this.getConsoleViewValue(ConsoleView::getContentSize);
        return result2 == null ? 0 : result2;
    }

    public boolean canPause() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::canPause);
        return result2 != null && result2 != false;
    }

    @Override
    @NotNull
    public AnAction[] createConsoleActions() {
        DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
        StopProcessAction stopAction = null;
        StartBuildEvent startBuildEvent = this.myStartBuildEventRef.get();
        if (startBuildEvent != null && startBuildEvent.getProcessHandler() != null) {
            stopAction = new StopProcessAction("Stop", "Stop", (ProcessHandler)startBuildEvent.getProcessHandler());
            AnAction generalStopAction = ActionManager.getInstance().getAction("Stop");
            if (generalStopAction != null) {
                stopAction.copyFrom(generalStopAction);
                stopAction.registerCustomShortcutSet(generalStopAction.getShortcutSet(), this);
            }
        }
        DefaultActionGroup consoleActionGroup = new DefaultActionGroup(){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                String eventViewName = BuildTreeConsoleView.class.getName();
                e.getPresentation().setVisible(!BuildView.this.isViewEnabled(eventViewName));
            }
        };
        ExecutionConsole consoleView = this.getConsoleView();
        if (consoleView instanceof ConsoleView) {
            AnAction[] consoleActions;
            for (AnAction anAction : consoleActions = ((ConsoleView)consoleView).createConsoleActions()) {
                if (anAction instanceof StopAction) {
                    if (stopAction != null) continue;
                    stopAction = anAction;
                    continue;
                }
                if (anAction instanceof FakeRerunAction || anAction instanceof PinActiveTabAction || anAction instanceof CloseAction) continue;
                consoleActionGroup.add(anAction);
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (startBuildEvent != null) {
            for (AnAction anAction : startBuildEvent.getRestartActions()) {
                rerunActionGroup.add(anAction);
            }
        }
        if (stopAction != null) {
            rerunActionGroup.add((AnAction)stopAction);
        }
        actionGroup.add((AnAction)rerunActionGroup);
        if (this.myViewManager.isBuildContentView()) {
            actionGroup.addAll(this.getSwitchActions());
            actionGroup.addSeparator();
        }
        return new AnAction[]{actionGroup, consoleActionGroup};
    }

    public void allowHeavyFilters() {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)ConsoleView::allowHeavyFilters));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this.getConsoleView();
        }
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        StartBuildEvent startBuildEvent = this.myStartBuildEventRef.get();
        if (startBuildEvent != null && LangDataKeys.RUN_PROFILE.is(dataId)) {
            ExecutionEnvironment environment = startBuildEvent.getExecutionEnvironment();
            return environment == null ? null : environment.getRunProfile();
        }
        if (startBuildEvent != null && LangDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return startBuildEvent.getExecutionEnvironment();
        }
        return null;
    }
}

