/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.build.events.SuccessResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends CachingSimpleNode {
    private static final Icon NODE_ICON_OK = AllIcons.RunConfigurations.TestPassed;
    private static final Icon NODE_ICON_ERROR = AllIcons.RunConfigurations.TestError;
    private static final Icon NODE_ICON_WARNING = AllIcons.General.Warning;
    private static final Icon NODE_ICON_INFO = AllIcons.General.Information;
    private static final Icon NODE_ICON_SKIPPED = AllIcons.RunConfigurations.TestIgnored;
    private static final Icon NODE_ICON_STATISTICS = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_SIMPLE = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_DEFAULT = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_RUNNING = new AnimatedIcon.FS(){

        protected Component getRendererOwner(Component component) {
            CellRendererPane pane;
            if (component instanceof JTree && !component.isShowing() && (pane = (CellRendererPane)UIUtil.getParentOfType(CellRendererPane.class, (Component)component)) != null) {
                return pane.getParent();
            }
            return null;
        }
    };
    private final List<ExecutionNode> myChildrenList = ContainerUtil.newSmartList();
    private long startTime;
    private long endTime;
    @Nullable
    private String myTitle;
    @Nullable
    private String myTooltip;
    @Nullable
    private String myHint;
    @Nullable
    private EventResult myResult;
    private boolean myAutoExpandNode;
    @Nullable
    private Navigatable myNavigatable;
    @Nullable
    private NullableLazyValue<Icon> myPreferredIconValue;
    private final AtomicInteger myErrors = new AtomicInteger();
    private final AtomicInteger myWarnings = new AtomicInteger();

    public ExecutionNode(Project aProject, ExecutionNode parentNode) {
        super(aProject, (NodeDescriptor)parentNode);
    }

    protected SimpleNode[] buildChildren() {
        return this.myChildrenList.toArray(NO_CHILDREN);
    }

    protected void update(@NotNull PresentationData presentation) {
        this.setIcon(this.getCurrentIcon());
        presentation.setPresentableText(this.myName);
        presentation.setIcon(this.getIcon());
        if (StringUtil.isNotEmpty((String)this.myTitle)) {
            presentation.addText(this.myTitle + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String hint = this.getCurrentHint();
        boolean isNotEmptyName = StringUtil.isNotEmpty((String)this.myName);
        if (isNotEmptyName && this.myTitle != null || hint != null) {
            presentation.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (StringUtil.isNotEmpty((String)hint)) {
            if (isNotEmptyName) {
                hint = " " + hint;
            }
            presentation.addText(hint, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.myTooltip != null) {
            presentation.setTooltip(this.myTooltip);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@Nullable String title) {
        this.myTitle = title;
    }

    @Nullable
    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(@Nullable String tooltip) {
        this.myTooltip = tooltip;
    }

    @Nullable
    public String getHint() {
        return this.myHint;
    }

    public void setHint(@Nullable String hint) {
        this.myHint = hint;
    }

    public void add(ExecutionNode node) {
        this.myChildrenList.add(node);
        this.cleanUpCache();
    }

    public void add(int index, ExecutionNode node) {
        this.myChildrenList.add(index, node);
        this.cleanUpCache();
    }

    void removeChildren() {
        this.myChildrenList.clear();
        this.cleanUpCache();
    }

    @Nullable
    public String getDuration() {
        if (this.startTime == this.endTime) {
            return null;
        }
        if (this.isRunning()) {
            long duration = this.startTime == 0L ? 0L : System.currentTimeMillis() - this.startTime;
            String durationText = StringUtil.formatDuration((long)duration);
            int index = durationText.indexOf("s ");
            if (index != -1) {
                durationText = durationText.substring(0, index + 1);
            }
            return "Running for " + durationText;
        }
        return ExecutionNode.isSkipped(this.myResult) ? null : StringUtil.formatDuration((long)(this.endTime - this.startTime));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public static boolean isFailed(@Nullable EventResult result2) {
        if (result2 instanceof FailureResult) {
            for (Failure failure : ((FailureResult)result2).getFailures()) {
                Notification notification = failure.getNotification();
                if (notification != null && notification.getType() != NotificationType.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasWarnings(@Nullable EventResult result2) {
        if (result2 instanceof FailureResult) {
            for (Failure failure : ((FailureResult)result2).getFailures()) {
                Notification notification = failure.getNotification();
                if (notification == null || notification.getType() != NotificationType.WARNING) continue;
                return true;
            }
        } else if (result2 instanceof SuccessResult) {
            return !((SuccessResult)result2).getWarnings().isEmpty();
        }
        return false;
    }

    public static boolean isSkipped(@Nullable EventResult result2) {
        return result2 instanceof SkippedResult;
    }

    public boolean isRunning() {
        return this.endTime <= 0L && !ExecutionNode.isSkipped(this.myResult) && !ExecutionNode.isFailed(this.myResult) && !ExecutionNode.hasWarnings(this.myResult);
    }

    public void setResult(@Nullable EventResult result2) {
        this.myResult = result2;
    }

    @Nullable
    public EventResult getResult() {
        return this.myResult;
    }

    public boolean isAutoExpandNode() {
        return this.myAutoExpandNode;
    }

    public void setAutoExpandNode(boolean autoExpandNode) {
        this.myAutoExpandNode = autoExpandNode;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.myNavigatable != null) {
            return Collections.singletonList(this.myNavigatable);
        }
        if (this.myResult == null) {
            return Collections.emptyList();
        }
        if (this.myResult instanceof FailureResult) {
            SmartList result2 = new SmartList();
            for (Failure failure : ((FailureResult)this.myResult).getFailures()) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)failure.getNavigatable());
            }
            return result2;
        }
        return Collections.emptyList();
    }

    public void setIconProvider(final Supplier<? extends Icon> iconProvider) {
        this.myPreferredIconValue = new NullableLazyValue<Icon>(){

            @Nullable
            protected Icon compute() {
                return (Icon)iconProvider.get();
            }
        };
    }

    public void reportChildMessageKind(MessageEvent.Kind kind) {
        if (kind == MessageEvent.Kind.ERROR) {
            this.myErrors.incrementAndGet();
        } else if (kind == MessageEvent.Kind.WARNING) {
            this.myWarnings.incrementAndGet();
        }
    }

    private String getCurrentHint() {
        String hint = this.myHint;
        int warnings = this.myWarnings.get();
        int errors = this.myErrors.get();
        if (warnings > 0 || errors > 0) {
            if (hint == null) {
                hint = "";
            }
            hint = hint + (this.getParent() == null ? (this.isRunning() ? "  " : "  with ") : " (");
            if (errors > 0) {
                hint = hint + errors + " " + StringUtil.pluralize((String)"error", (int)errors);
                if (warnings > 0) {
                    hint = hint + ", ";
                }
            }
            if (warnings > 0) {
                hint = hint + warnings + " " + StringUtil.pluralize((String)"warning", (int)warnings);
            }
            if (this.getParent() != null) {
                hint = hint + ")";
            }
        }
        return hint;
    }

    private Icon getCurrentIcon() {
        if (this.myPreferredIconValue != null) {
            return (Icon)this.myPreferredIconValue.getValue();
        }
        if (this.myResult instanceof MessageEventResult) {
            return ExecutionNode.getIcon(((MessageEventResult)this.myResult).getKind());
        }
        return this.isRunning() ? NODE_ICON_RUNNING : (ExecutionNode.isFailed(this.myResult) ? NODE_ICON_ERROR : (ExecutionNode.isSkipped(this.myResult) ? NODE_ICON_SKIPPED : (this.myErrors.get() > 0 ? NODE_ICON_ERROR : (ExecutionNode.hasWarnings(this.myResult) || this.myWarnings.get() > 0 ? NODE_ICON_WARNING : NODE_ICON_OK))));
    }

    public static Icon getEventResultIcon(@Nullable EventResult result2) {
        if (result2 == null) {
            return NODE_ICON_RUNNING;
        }
        if (ExecutionNode.isFailed(result2)) {
            return NODE_ICON_ERROR;
        }
        if (ExecutionNode.isSkipped(result2)) {
            return NODE_ICON_SKIPPED;
        }
        return NODE_ICON_OK;
    }

    private static Icon getIcon(MessageEvent.Kind kind) {
        switch (kind) {
            case ERROR: {
                return NODE_ICON_ERROR;
            }
            case WARNING: {
                return NODE_ICON_WARNING;
            }
            case INFO: {
                return NODE_ICON_INFO;
            }
            case STATISTICS: {
                return NODE_ICON_STATISTICS;
            }
            case SIMPLE: {
                return NODE_ICON_SIMPLE;
            }
        }
        return NODE_ICON_DEFAULT;
    }
}

