/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.events.impl;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageEventImpl
extends AbstractBuildEvent
implements MessageEvent {
    @NotNull
    private final MessageEvent.Kind myKind;
    @NotNull
    private final String myGroup;

    public MessageEventImpl(@NotNull Object parentId, @NotNull MessageEvent.Kind kind, @Nullable String group, @NotNull String message, @Nullable String detailedMessage) {
        super(new Object(), parentId, System.currentTimeMillis(), message);
        this.myKind = kind;
        this.myGroup = group == null ? "Other messages" : group;
        this.setDescription(detailedMessage);
    }

    @Override
    public final void setDescription(@Nullable String description) {
        super.setDescription(description);
    }

    @NotNull
    public MessageEvent.Kind getKind() {
        return this.myKind;
    }

    @NotNull
    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        return null;
    }

    public MessageEventResult getResult() {
        return new MessageEventResult(){

            public MessageEvent.Kind getKind() {
                return MessageEventImpl.this.myKind;
            }

            public String getDetails() {
                return MessageEventImpl.this.getDescription();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEventImpl event = (MessageEventImpl)o;
        return Objects.equals(this.getMessage(), event.getMessage()) && Objects.equals(this.getDescription(), event.getDescription()) && Objects.equals(this.myGroup, event.myGroup);
    }

    public int hashCode() {
        return Objects.hash(this.myGroup, this.getMessage());
    }
}

